/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.ssh.multiplexer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.construct.Flow;
import org.mule.modules.ssh.multiplexer.CallbackOutputStream;

public class SshConnector
implements MuleContextAware {
    private static final Logger logger = Logger.getLogger(SshConnector.class);
    private static final String SSH_CALLBACK_USER = "SSH_CALLBACK_USER";
    private MuleContext muleContext;
    private Integer timeout;
    private String callbackFlowName;
    private boolean shellMode = false;
    private Flow callbackFlow = null;
    private Integer receiverBufferSize = 8192;
    private SSHClient client;
    private Session session;
    private OutputStream writerStream;
    private OutputStream callbackStream;
    private Session.Shell shell;
    private String username;

    public void init() {
        this.callbackFlow = (Flow)this.muleContext.getRegistry().lookupFlowConstruct(this.callbackFlowName);
        if (this.callbackFlow == null) {
            throw new IllegalArgumentException("Could not find callback flow with name " + this.callbackFlowName);
        }
    }

    public void connect(String username, String password, String host, Integer port) throws ConnectionException {
        this.client = new SSHClient();
        try {
            this.client.loadKnownHosts();
        }
        catch (IOException e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, e.getMessage(), "Error loading known hosts");
        }
        if (this.timeout != null) {
            this.client.setTimeout(this.timeout);
            this.client.getTransport().setTimeout(this.timeout);
        }
        try {
            this.client.connect(host, (int)port);
        }
        catch (IOException e) {
            throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, e.getMessage(), String.format("Could not reach ssh server at %s:%d", host, port));
        }
        try {
            this.client.authPassword(username, password);
            this.session = this.client.startSession();
        }
        catch (UserAuthException e) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, e.getMessage(), "Could not login");
        }
        catch (TransportException e) {
            this.throwCannotReachException(e);
        }
        catch (net.schmizz.sshj.connection.ConnectionException e) {
            this.throwCannotReachException(e);
        }
        this.username = username;
        if (this.isShellMode()) {
            try {
                this.session.allocateDefaultPTY();
                this.shell = this.session.startShell();
            }
            catch (TransportException e) {
                this.throwCannotReachException(e);
            }
            catch (net.schmizz.sshj.connection.ConnectionException e) {
                this.throwCannotReachException(e);
            }
            int bufSize = this.shell.getLocalMaxPacketSize();
            this.writerStream = this.shell.getOutputStream();
            this.callbackStream = new CallbackOutputStream(this, bufSize);
            new StreamCopier(this.shell.getInputStream(), this.callbackStream).bufSize(bufSize).spawn(String.format("SSH reader thread for user %s", this.username));
            new StreamCopier(this.shell.getErrorStream(), this.callbackStream).bufSize(bufSize).spawn(String.format("SSH error thread for user %s", this.username));
        }
    }

    public void disconnect() {
        if (this.shell != null) {
            try {
                this.shell.close();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Error found closing shell for user %s", this.username), (Throwable)e);
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Error found closing session for user %s", this.username), (Throwable)e);
            }
        }
        if (this.client != null) {
            try {
                this.client.disconnect();
            }
            catch (IOException e) {
                logger.error((Object)String.format("Error found closing client for user %s", this.username), (Throwable)e);
            }
        }
    }

    public boolean isConnected() {
        return this.client != null && this.client.isConnected() && this.client.isAuthenticated() && this.session != null && this.session.isOpen() && (this.shell == null || this.shell.isOpen());
    }

    public String getConnectionIdentifier() {
        return this.username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(String content, boolean breakLine) throws IOException {
        String string = content = breakLine ? content + "\n" : content;
        if (this.shellMode) {
            this.writerStream.write(content.getBytes());
            this.writerStream.flush();
            return;
        }
        Session.Command cmd = null;
        try {
            cmd = this.session.exec(content);
            this.doCallback(IOUtils.readFully(cmd.getInputStream()).toString());
        }
        catch (Throwable throwable) {
            try {
                if (cmd == null) throw throwable;
                cmd.close();
                throw throwable;
            }
            catch (Exception e) {
                logger.error((Object)String.format("Error found closing command %s for user %s", content, this.username), (Throwable)e);
            }
            throw throwable;
        }
        try {
            if (cmd == null) return;
            cmd.close();
            return;
        }
        catch (Exception e) {
            logger.error((Object)String.format("Error found closing command %s for user %s", content, this.username), (Throwable)e);
            return;
        }
    }

    protected void doCallback(String response) {
        if (!StringUtils.isEmpty((String)response)) {
            HashMap<String, String> inbound = new HashMap<String, String>();
            inbound.put(SSH_CALLBACK_USER, this.username);
            DefaultMuleMessage message = new DefaultMuleMessage((Object)response, inbound, null, null, this.muleContext);
            DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)this.callbackFlow);
            try {
                this.callbackFlow.process((MuleEvent)event);
            }
            catch (MuleException e) {
                logger.error((Object)"Error invoking callback flow", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    private void throwCannotReachException(Exception e) throws ConnectionException {
        throw new ConnectionException(ConnectionExceptionCode.CANNOT_REACH, e.getMessage(), e.getMessage());
    }

    public boolean isShellMode() {
        return this.shellMode;
    }

    public void setShellMode(boolean shellMode) {
        this.shellMode = shellMode;
    }

    public String getCallbackFlowName() {
        return this.callbackFlowName;
    }

    public void setCallbackFlowName(String callbackFlowName) {
        this.callbackFlowName = callbackFlowName;
    }

    public Integer getReceiverBufferSize() {
        return this.receiverBufferSize;
    }

    public void setReceiverBufferSize(Integer receiverBufferSize) {
        if (receiverBufferSize < 1) {
            throw new IllegalArgumentException("ReceiverBufferSize must be greater or equal than 1");
        }
        this.receiverBufferSize = receiverBufferSize;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

