
package org.mule.modules.ssh.multiplexer.processors;

import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.modules.ssh.multiplexer.SshConnector;
import org.mule.modules.ssh.multiplexer.connectivity.SshConnectorConnectionManager;
import org.mule.modules.ssh.multiplexer.process.ProcessAdapter;
import org.mule.modules.ssh.multiplexer.process.ProcessCallback;
import org.mule.modules.ssh.multiplexer.process.ProcessTemplate;


/**
 * SendMessageProcessor invokes the {@link org.mule.modules.ssh.multiplexer.SshConnector#send(java.lang.String, boolean)} method in {@link SshConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-05-07T06:38:32-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class SendMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object content;
    protected String _contentType;
    protected Object breakLine;
    protected boolean _breakLineType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets content
     * 
     * @param value Value to set
     */
    public void setContent(Object value) {
        this.content = value;
    }

    /**
     * Sets breakLine
     * 
     * @param value Value to set
     */
    public void setBreakLine(Object value) {
        this.breakLine = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(SshConnectorConnectionManager.class, false, event);
            final String _transformedContent = ((String) evaluateAndTransform(getMuleContext(), event, SendMessageProcessor.class.getDeclaredField("_contentType").getGenericType(), null, content));
            final Boolean _transformedBreakLine = ((Boolean) evaluateAndTransform(getMuleContext(), event, SendMessageProcessor.class.getDeclaredField("_breakLineType").getGenericType(), null, breakLine));
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    ((SshConnector) object).send(_transformedContent, _transformedBreakLine);
                    return null;
                }

            }
            , this, event);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("send"), event, e);
        }
    }

}
