
package org.mule.modules.ssh.multiplexer.connectivity;

import javax.annotation.Generated;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleProperties;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.config.PoolingProfile;
import org.mule.modules.ssh.multiplexer.SshConnector;
import org.mule.modules.ssh.multiplexer.adapters.SshConnectorConnectionIdentifierAdapter;
import org.mule.modules.ssh.multiplexer.basic.Capabilities;
import org.mule.modules.ssh.multiplexer.basic.Capability;
import org.mule.modules.ssh.multiplexer.basic.MetadataAware;
import org.mule.modules.ssh.multiplexer.connection.ConnectionManager;
import org.mule.modules.ssh.multiplexer.process.ProcessAdapter;
import org.mule.modules.ssh.multiplexer.process.ProcessTemplate;


/**
 * A {@code SshConnectorConnectionManager} is a wrapper around {@link SshConnector } that adds connection management capabilities to the pojo.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-05-07T06:38:32-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class SshConnectorConnectionManager implements MuleContextAware, Initialisable, Capabilities, MetadataAware, ConnectionManager<SshConnectorConnectionKey, SshConnectorConnectionIdentifierAdapter> , ProcessAdapter<SshConnectorConnectionIdentifierAdapter>
{

    /**
     * 
     */
    private String username;
    /**
     * 
     */
    private String password;
    /**
     * 
     */
    private String host;
    /**
     * 
     */
    private Integer port;
    private Integer timeout;
    private String callbackFlowName;
    private boolean shellMode;
    private Integer receiverBufferSize;
    /**
     * Mule Context
     * 
     */
    protected MuleContext muleContext;
    /**
     * Flow Construct
     * 
     */
    protected FlowConstruct flowConstruct;
    /**
     * Connector Pool
     * 
     */
    private GenericKeyedObjectPool connectionPool;
    protected PoolingProfile connectionPoolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private final static String MODULE_NAME = "SSH";
    private final static String MODULE_VERSION = "1.2.1";
    private final static String DEVKIT_VERSION = "3.4.0";
    private final static String DEVKIT_BUILD = "3.4.0.1555.8df15c1";

    /**
     * Sets timeout
     * 
     * @param value Value to set
     */
    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    /**
     * Retrieves timeout
     * 
     */
    public Integer getTimeout() {
        return this.timeout;
    }

    /**
     * Sets callbackFlowName
     * 
     * @param value Value to set
     */
    public void setCallbackFlowName(String value) {
        this.callbackFlowName = value;
    }

    /**
     * Retrieves callbackFlowName
     * 
     */
    public String getCallbackFlowName() {
        return this.callbackFlowName;
    }

    /**
     * Sets shellMode
     * 
     * @param value Value to set
     */
    public void setShellMode(boolean value) {
        this.shellMode = value;
    }

    /**
     * Retrieves shellMode
     * 
     */
    public boolean getShellMode() {
        return this.shellMode;
    }

    /**
     * Sets receiverBufferSize
     * 
     * @param value Value to set
     */
    public void setReceiverBufferSize(Integer value) {
        this.receiverBufferSize = value;
    }

    /**
     * Retrieves receiverBufferSize
     * 
     */
    public Integer getReceiverBufferSize() {
        return this.receiverBufferSize;
    }

    /**
     * Sets muleContext
     * 
     * @param value Value to set
     */
    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    /**
     * Retrieves muleContext
     * 
     */
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    /**
     * Sets flowConstruct
     * 
     * @param value Value to set
     */
    public void setFlowConstruct(FlowConstruct value) {
        this.flowConstruct = value;
    }

    /**
     * Retrieves flowConstruct
     * 
     */
    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    /**
     * Sets connectionPoolingProfile
     * 
     * @param value Value to set
     */
    public void setConnectionPoolingProfile(PoolingProfile value) {
        this.connectionPoolingProfile = value;
    }

    /**
     * Retrieves connectionPoolingProfile
     * 
     */
    public PoolingProfile getConnectionPoolingProfile() {
        return this.connectionPoolingProfile;
    }

    /**
     * Sets retryPolicyTemplate
     * 
     * @param value Value to set
     */
    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    /**
     * Retrieves retryPolicyTemplate
     * 
     */
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    /**
     * Sets port
     * 
     * @param value Value to set
     */
    public void setPort(Integer value) {
        this.port = value;
    }

    /**
     * Retrieves port
     * 
     */
    public Integer getPort() {
        return this.port;
    }

    /**
     * Sets username
     * 
     * @param value Value to set
     */
    public void setUsername(String value) {
        this.username = value;
    }

    /**
     * Retrieves username
     * 
     */
    public String getUsername() {
        return this.username;
    }

    /**
     * Sets host
     * 
     * @param value Value to set
     */
    public void setHost(String value) {
        this.host = value;
    }

    /**
     * Retrieves host
     * 
     */
    public String getHost() {
        return this.host;
    }

    /**
     * Sets password
     * 
     * @param value Value to set
     */
    public void setPassword(String value) {
        this.password = value;
    }

    /**
     * Retrieves password
     * 
     */
    public String getPassword() {
        return this.password;
    }

    public void initialise() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        if (connectionPoolingProfile!= null) {
            config.maxIdle = connectionPoolingProfile.getMaxIdle();
            config.maxActive = connectionPoolingProfile.getMaxActive();
            config.maxWait = connectionPoolingProfile.getMaxWait();
            config.whenExhaustedAction = ((byte) connectionPoolingProfile.getExhaustedAction());
        }
        connectionPool = new GenericKeyedObjectPool(new SshConnectorConnectionFactory(this), config);
        if (retryPolicyTemplate == null) {
            retryPolicyTemplate = muleContext.getRegistry().lookupObject(MuleProperties.OBJECT_DEFAULT_RETRY_POLICY_TEMPLATE);
        }
    }

    public SshConnectorConnectionIdentifierAdapter acquireConnection(SshConnectorConnectionKey key)
        throws Exception
    {
        return ((SshConnectorConnectionIdentifierAdapter) connectionPool.borrowObject(key));
    }

    public void releaseConnection(SshConnectorConnectionKey key, SshConnectorConnectionIdentifierAdapter connection)
        throws Exception
    {
        connectionPool.returnObject(key, connection);
    }

    public void destroyConnection(SshConnectorConnectionKey key, SshConnectorConnectionIdentifierAdapter connection)
        throws Exception
    {
        connectionPool.invalidateObject(key, connection);
    }

    /**
     * Returns true if this module implements such capability
     * 
     */
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        if (capability == Capability.CONNECTION_MANAGEMENT_CAPABLE) {
            return true;
        }
        return false;
    }

    @Override
    public<P >ProcessTemplate<P, SshConnectorConnectionIdentifierAdapter> getProcessTemplate() {
        return new ManagedConnectionProcessTemplate(this, muleContext);
    }

    public SshConnectorConnectionKey getDefaultConnectionKey() {
        return new SshConnectorConnectionKey(getUsername(), getPassword(), getHost(), getPort());
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

}
