/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package net.schmizz.sshj.signature;

import java.security.PrivateKey;
import java.security.PublicKey;

/** Signature interface for SSH used to sign or verify data. Usually wraps a {@code javax.crypto.Signature} object. */
public interface Signature {

    /**
     * Initialize this signature with the given public key and private key. If the private key is null, only signature
     * verification can be performed.
     *
     * @param pubkey (null-ok) specify in case verification is needed
     * @param prvkey (null-ok) specify in case signing is needed
     */
    void init(PublicKey pubkey, PrivateKey prvkey);

    /**
     * Convenience method, same as calling {@link #update(byte[], int, int)} with offset as {@code 0} and {@code
     * H.length}.
     *
     * @param H the byte-array to update with
     */
    void update(byte[] H);

    /**
     * Update the computed signature with the given data.
     *
     * @param H   byte-array to update with
     * @param off offset within the array
     * @param len length until which to compute
     */
    void update(byte[] H, int off, int len);

    /**
     * Compute the signature.
     *
     * @return the computed signature
     */
    byte[] sign();

    /**
     * Verify against the given signature.
     *
     * @param sig the signature to verify against
     *
     * @return {@code true} on successful verification, {@code false} on failure
     */
    boolean verify(byte[] sig);

}
