
package org.mule.modules.ssh.multiplexer.config.spring;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/sshmultiplexedconnector</code>.
 * 
 */
public class SshMultiplexedConnectorNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new SshMultiplexedConnectorConfigDefinitionParser());
        registerBeanDefinitionParser("send", new SendDefinitionParser());
        registerBeanDefinitionParser("release", new ReleaseDefinitionParser());
    }

}
