
package org.mule.modules.ssh.multiplexer.config.spring;

import org.apache.commons.lang.StringUtils;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.modules.ssh.multiplexer.config.SshMultiplexedConnectorLifecycleAdapter;
import org.mule.util.TemplateParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SshMultiplexedConnectorConfigDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public SshMultiplexedConnectorConfigDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        String name = element.getAttribute("name");
        if ((name == null)||StringUtils.isBlank(name)) {
            element.setAttribute("name", AutoIdUtils.getUniqueName(element, "mule-bean"));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(SshMultiplexedConnectorLifecycleAdapter.class.getName());
        if (Initialisable.class.isAssignableFrom(SshMultiplexedConnectorLifecycleAdapter.class)) {
            builder.setInitMethodName(Initialisable.PHASE_NAME);
        }
        if (Disposable.class.isAssignableFrom(SshMultiplexedConnectorLifecycleAdapter.class)) {
            builder.setDestroyMethodName(Disposable.PHASE_NAME);
        }
        if ((element.getAttribute("host")!= null)&&(!StringUtils.isBlank(element.getAttribute("host")))) {
            builder.addPropertyValue("host", element.getAttribute("host"));
        }
        if ((element.getAttribute("port")!= null)&&(!StringUtils.isBlank(element.getAttribute("port")))) {
            builder.addPropertyValue("port", element.getAttribute("port"));
        }
        if ((element.getAttribute("timeout")!= null)&&(!StringUtils.isBlank(element.getAttribute("timeout")))) {
            builder.addPropertyValue("timeout", element.getAttribute("timeout"));
        }
        if ((element.getAttribute("callbackFlowName")!= null)&&(!StringUtils.isBlank(element.getAttribute("callbackFlowName")))) {
            builder.addPropertyValue("callbackFlowName", element.getAttribute("callbackFlowName"));
        }
        if ((element.getAttribute("shellMode")!= null)&&(!StringUtils.isBlank(element.getAttribute("shellMode")))) {
            builder.addPropertyValue("shellMode", element.getAttribute("shellMode"));
        }
        if ((element.getAttribute("receiverBufferSize")!= null)&&(!StringUtils.isBlank(element.getAttribute("receiverBufferSize")))) {
            builder.addPropertyValue("receiverBufferSize", element.getAttribute("receiverBufferSize"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        return definition;
    }

}
