/*
 * Decompiled with CFR 0.152.
 */
package com.cookbook.tutorial.client;

import com.cookbook.tutorial.client.ICookbookCallback;
import com.cookbook.tutorial.client.IMuleCookBookClient;
import com.cookbook.tutorial.service.AddList;
import com.cookbook.tutorial.service.CookBookEntity;
import com.cookbook.tutorial.service.Create;
import com.cookbook.tutorial.service.Delete;
import com.cookbook.tutorial.service.DeleteList;
import com.cookbook.tutorial.service.DescribeEntity;
import com.cookbook.tutorial.service.Description;
import com.cookbook.tutorial.service.Get;
import com.cookbook.tutorial.service.GetList;
import com.cookbook.tutorial.service.IMuleCookBookService;
import com.cookbook.tutorial.service.IMuleCookBookServiceService;
import com.cookbook.tutorial.service.InvalidCredentialsException;
import com.cookbook.tutorial.service.InvalidEntityException;
import com.cookbook.tutorial.service.InvalidRequestException;
import com.cookbook.tutorial.service.InvalidTokenException;
import com.cookbook.tutorial.service.NoSuchEntityException;
import com.cookbook.tutorial.service.ObjectFactory;
import com.cookbook.tutorial.service.Recipe;
import com.cookbook.tutorial.service.SearchWithQuery;
import com.cookbook.tutorial.service.SessionExpiredException;
import com.cookbook.tutorial.service.Update;
import com.cookbook.tutorial.service.UpdateList;
import java.util.List;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleCookBookClient
implements IMuleCookBookClient {
    private static final Logger logger = LoggerFactory.getLogger(MuleCookBookClient.class);
    private IMuleCookBookService port;
    private String token;
    ObjectFactory factory;

    public MuleCookBookClient() {
        IMuleCookBookServiceService ss = new IMuleCookBookServiceService();
        this.factory = new ObjectFactory();
        this.port = ss.getIMuleCookBookServicePort();
    }

    public String toString() {
        return super.toString();
    }

    public MuleCookBookClient(String address) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(IMuleCookBookService.class);
        this.factory = new ObjectFactory();
        this.port = (IMuleCookBookService)factory.create();
        ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", address);
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public void login(String username, String password) throws InvalidCredentialsException {
        this.token = this.port.login(username, password);
    }

    @Override
    public List<Recipe> getRecentlyAdded() {
        return this.port.getRecentlyAdded();
    }

    @Override
    public void getRecentlyAdded(ICookbookCallback callback) throws Exception {
        callback.execute(this.port.getRecentlyAdded());
    }

    @Override
    public CookBookEntity get(int id) throws NoSuchEntityException, SessionExpiredException {
        Get request = this.factory.createGet();
        request.setId(id);
        try {
            return this.port.get(request, this.token).getReturn();
        }
        catch (InvalidTokenException e) {
            logger.warn("Should never happen.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<CookBookEntity> searchWithQuery(String query, Integer page, Integer pageSize) throws InvalidRequestException, SessionExpiredException {
        SearchWithQuery request = this.factory.createSearchWithQuery();
        request.setPage(page);
        request.setPageSize(pageSize);
        request.setQuery(query);
        try {
            return this.port.searchWithQuery(request, this.token).getReturn();
        }
        catch (InvalidTokenException e) {
            logger.warn("Should never happen.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public CookBookEntity update(CookBookEntity entity) throws NoSuchEntityException, InvalidEntityException, SessionExpiredException {
        Update request = this.factory.createUpdate();
        request.setEntity(entity);
        try {
            return this.port.update(request, this.token).getReturn();
        }
        catch (InvalidTokenException e) {
            logger.warn("Should never happen.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<CookBookEntity> addList(List<CookBookEntity> entities) throws InvalidEntityException, SessionExpiredException {
        AddList request = this.factory.createAddList();
        request.setEntities(entities);
        try {
            return this.port.addList(request, this.token).getReturn();
        }
        catch (InvalidTokenException e) {
            logger.warn("Should never happen.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<CookBookEntity> getList(List<Integer> entityIds) throws NoSuchEntityException, SessionExpiredException {
        GetList getList = this.factory.createGetList();
        getList.setEntityIds(entityIds);
        try {
            return this.port.getList(getList, this.token).getReturn();
        }
        catch (InvalidTokenException e) {
            logger.warn("Should never happen.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(int id) throws NoSuchEntityException, SessionExpiredException {
        Delete delete = this.factory.createDelete();
        delete.setId(id);
        try {
            this.port.delete(delete, this.token);
        }
        catch (InvalidTokenException e) {
            logger.warn("Should never happen.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<CookBookEntity> updateList(List<CookBookEntity> entities) throws NoSuchEntityException, InvalidEntityException, SessionExpiredException {
        UpdateList request = this.factory.createUpdateList();
        request.setEntities(entities);
        try {
            return this.port.updateList(request, this.token).getReturn();
        }
        catch (InvalidTokenException e) {
            logger.warn("Should never happen.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteList(List<Integer> entityIds) throws NoSuchEntityException, SessionExpiredException {
        DeleteList request = this.factory.createDeleteList();
        request.setEntityIds(entityIds);
        try {
            this.port.deleteList(request, this.token);
        }
        catch (InvalidTokenException e) {
            logger.warn("Should never happen.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public CookBookEntity create(CookBookEntity entity) throws InvalidEntityException, SessionExpiredException {
        Create request = this.factory.createCreate();
        request.setEntity(entity);
        try {
            return this.port.create(request, this.token).getReturn();
        }
        catch (InvalidTokenException e) {
            logger.warn("Should never happen.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<CookBookEntity> getEntities() throws SessionExpiredException {
        try {
            return this.port.getEntitiesList(this.factory.createGetEntitiesList(), this.token).getReturn();
        }
        catch (InvalidTokenException e) {
            logger.warn("Should never happen.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public Description describeEntity(CookBookEntity cookBookEntity) throws InvalidTokenException, InvalidEntityException, NoSuchEntityException, SessionExpiredException {
        DescribeEntity parameters = this.factory.createDescribeEntity();
        parameters.setEntity(cookBookEntity);
        return this.port.describeEntity(parameters, this.token).getReturn();
    }
}

