/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.ip.address;

import java.util.regex.Pattern;
import org.mule.extension.validation.internal.ip.address.IPAddress;
import org.mule.extension.validation.internal.ip.address.IPv4Address;
import org.mule.extension.validation.internal.ip.address.IPv6Address;
import org.mule.extension.validation.internal.ip.address.InvalidIPAddress;

public class IPAddressFactory {
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    public IPAddress create(String ipAddress) {
        if (this.isIPv4(ipAddress)) {
            return new IPv4Address(ipAddress);
        }
        if (this.isIPv6(ipAddress)) {
            return new IPv6Address(ipAddress);
        }
        return new InvalidIPAddress(ipAddress);
    }

    private boolean isIPv4(String input) {
        return IPV4_PATTERN.matcher(input).matches();
    }

    private boolean isIPv6(String input) {
        return this.isIPv6Std(input) || this.isIPv6HexCompressed(input);
    }

    private boolean isIPv6Std(String input) {
        String ip = input.indexOf("%") > 0 ? input.substring(0, input.indexOf("%")) : input;
        return IPV6_STD_PATTERN.matcher(ip).matches();
    }

    private boolean isIPv6HexCompressed(String input) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
    }
}

