/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import org.mule.extension.validation.api.ValidationErrorType;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;

public class NotNullValidator
extends AbstractValidator {
    private final TypedValue<Object> value;
    private final ExpressionLanguage expressionLanguage;

    public NotNullValidator(TypedValue<Object> value, ValidationContext validationContext, ExpressionLanguage expressionLanguage) {
        super(validationContext);
        this.value = value;
        this.expressionLanguage = expressionLanguage;
    }

    @Override
    public ValidationResult validate() {
        if (this.value == null) {
            return this.fail();
        }
        BindingContext ctx = BindingContext.builder().addBinding("payload", this.value).build();
        TypedValue eval = this.expressionLanguage.evaluate("payload != null", DataType.BOOLEAN, ctx);
        return (Boolean)eval.getValue() != false ? ImmutableValidationResult.ok() : this.fail();
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.NULL;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.getMessages().valueIsNull();
    }
}

