/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.extension.validation.api.ValidationErrorType;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.util.Preconditions;

public class SizeValidator
extends AbstractValidator {
    private final Object value;
    private final int minSize;
    private final Integer maxSize;
    private I18nMessage errorMessage;

    public SizeValidator(Object value, int minSize, Integer maxSize, ValidationContext validationContext) {
        super(validationContext);
        this.value = value;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    @Override
    public ValidationResult validate() {
        int inputLength = this.getSize(this.value);
        if (inputLength < this.minSize) {
            this.errorMessage = this.getMessages().lowerThanMinSize(this.value, this.minSize, inputLength);
            return this.fail();
        }
        if (this.maxSize != null && inputLength > this.maxSize) {
            this.errorMessage = this.getMessages().greaterThanMaxSize(this.value, this.maxSize, inputLength);
            return this.fail();
        }
        return ImmutableValidationResult.ok();
    }

    private int getSize(Object value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Cannot check size of a null value");
        if (value instanceof String) {
            return ((String)value).length();
        }
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value instanceof Map) {
            return ((Map)value).size();
        }
        if (value.getClass().isArray()) {
            return ArrayUtils.getLength((Object)value);
        }
        throw new IllegalArgumentException(String.format("Only instances of Map, Collection, Array and String can be checked for size. Instance of %s was found instead", value.getClass().getName()));
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.INVALID_SIZE;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.errorMessage;
    }
}

