/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.api;

import java.util.Objects;
import org.mule.extension.validation.api.Validator;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.ClassValue;

@ExclusiveOptionals(isOneRequired=true)
public final class CustomValidatorFactory {
    private MuleContext muleContext;
    @Parameter
    @Alias(value="class")
    @Optional
    @ClassValue(extendsOrImplements={"org.mule.extension.validation.api.Validator"})
    private String type;
    @Parameter
    @Optional
    @ParameterDsl(allowInlineDefinition=false)
    private Validator ref;

    public CustomValidatorFactory() {
    }

    public CustomValidatorFactory(String type, Validator ref) {
        this.type = type;
        this.ref = ref;
    }

    public final Validator getObject() {
        return !StringUtils.isBlank((String)this.type) ? this.doGetByClassName(this.muleContext) : this.ref;
    }

    protected Validator doGetByClassName(MuleContext muleContext) {
        Class objectClass;
        Preconditions.checkArgument((muleContext != null ? 1 : 0) != 0, (String)"Mule Context is required for loading a Validator class");
        try {
            objectClass = ClassUtils.loadClass((String)this.type, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(String.format("Could not find class %s", this.type), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Could %s is not a %s", this.type, Validator.class.getName()), e);
        }
        try {
            Validator validator = (Validator)objectClass.newInstance();
            muleContext.getInjector().inject((Object)validator);
            return validator;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create instance of " + this.type)), (Throwable)e);
        }
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Validator getRef() {
        return this.ref;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (other instanceof CustomValidatorFactory) {
            CustomValidatorFactory that = (CustomValidatorFactory)other;
            return Objects.equals(this.type, that.type) && Objects.equals(this.ref, that.ref);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.ref);
    }
}

