/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.api.error.ValidationErrorType;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.i18n.I18nMessage;

public class EmailValidator
extends AbstractValidator {
    private final String email;

    public EmailValidator(String email, ValidationContext validationContext) {
        super(validationContext);
        this.email = email;
    }

    @Override
    public ValidationResult validate() {
        if (!this.email.trim().equals(this.email)) {
            return this.fail();
        }
        return org.apache.commons.validator.routines.EmailValidator.getInstance().isValid(this.email) ? ImmutableValidationResult.ok() : this.fail();
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.INVALID_EMAIL;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.getMessages().invalidEmail(this.email);
    }
}

