/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import java.net.MalformedURLException;
import java.net.URL;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.api.error.ValidationErrorType;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.i18n.I18nMessage;

public class UrlValidator
extends AbstractValidator {
    private final String url;

    public UrlValidator(String url, ValidationContext validationContext) {
        super(validationContext);
        this.url = url;
    }

    @Override
    public ValidationResult validate() {
        try {
            new URL(this.url);
            return ImmutableValidationResult.ok();
        }
        catch (MalformedURLException e) {
            return this.fail();
        }
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.INVALID_URL;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.getMessages().invalidUrl(this.url);
    }
}

