/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import java.util.Collection;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.api.error.ValidationErrorType;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.i18n.I18nMessage;

public class EmptyCollectionValidator
extends AbstractValidator {
    private final Collection<?> value;
    private I18nMessage errorMessage;

    public EmptyCollectionValidator(Collection<?> value, ValidationContext validationContext) {
        super(validationContext);
        this.value = value;
    }

    @Override
    public ValidationResult validate() {
        if (this.value != null && !this.value.isEmpty()) {
            this.errorMessage = this.getMessages().collectionIsNotEmpty();
            return this.fail();
        }
        return ImmutableValidationResult.ok();
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.NOT_EMPTY_COLLECTION;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.errorMessage;
    }
}

