/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import org.apache.commons.validator.routines.RegexValidator;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.api.error.ValidationErrorType;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.i18n.I18nMessage;

public class MatchesRegexValidator
extends AbstractValidator {
    private final String value;
    private final String regex;
    private final boolean caseSensitive;

    public MatchesRegexValidator(String value, String regex, boolean caseSensitive, ValidationContext validationContext) {
        super(validationContext);
        this.value = value;
        this.regex = regex;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public ValidationResult validate() {
        RegexValidator validator = new RegexValidator(new String[]{this.regex}, this.caseSensitive);
        return validator.isValid(this.value) ? ImmutableValidationResult.ok() : this.fail();
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.MISMATCH;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.getMessages().regexDoesNotMatch(this.value, this.regex);
    }
}

