/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.api.error.ValidationErrorType;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.i18n.I18nMessage;

public class EmptyValidator
extends AbstractValidator {
    private final Object value;
    private I18nMessage errorMessage;

    public EmptyValidator(Object value, ValidationContext validationContext) {
        super(validationContext);
        this.value = value;
    }

    @Override
    public ValidationResult validate() {
        if (this.value == null) {
            return ImmutableValidationResult.ok();
        }
        if (this.value instanceof String) {
            if (!StringUtils.isBlank((CharSequence)((String)this.value))) {
                this.errorMessage = this.getMessages().stringIsNotBlank();
                return this.fail();
            }
        } else if (this.value instanceof Collection) {
            if (!((Collection)this.value).isEmpty()) {
                this.errorMessage = this.getMessages().collectionIsNotEmpty();
                return this.fail();
            }
        } else if (this.value instanceof Map) {
            if (!((Map)this.value).isEmpty()) {
                this.errorMessage = this.getMessages().mapIsNotEmpty();
                return this.fail();
            }
        } else if (this.value.getClass().isArray()) {
            if (this.value != null && ArrayUtils.getLength((Object)this.value) > 0) {
                this.errorMessage = this.getMessages().arrayIsNotEmpty();
                return this.fail();
            }
        } else {
            throw new IllegalArgumentException(String.format("Only instances of Map, Collection, Array and String can be checked for emptyness. Instance of %s was found instead", this.value.getClass().getName()));
        }
        return ImmutableValidationResult.ok();
    }

    @Override
    protected ValidationErrorType getErrorType() {
        return ValidationErrorType.NOT_EMPTY;
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.errorMessage;
    }
}

