/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.mule.extension.validation.api.MultipleValidationResult;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.api.error.ValidationErrorType;

public final class ImmutableMultipleValidationResult
implements MultipleValidationResult {
    private final List<ValidationResult> failedResults;
    private final boolean error;
    private final String message;

    public static MultipleValidationResult of(Iterable<ValidationResult> results) {
        ImmutableList.Builder failedResultsBuilder = ImmutableList.builder();
        StringBuilder message = new StringBuilder();
        boolean error = false;
        for (ValidationResult result : results) {
            if (!result.isError()) continue;
            failedResultsBuilder.add((Object)result);
            if (message.length() > 0) {
                message.append('\n');
            }
            message.append(result.getMessage());
            error = true;
        }
        return new ImmutableMultipleValidationResult((List<ValidationResult>)failedResultsBuilder.build(), error, message.toString());
    }

    private ImmutableMultipleValidationResult(List<ValidationResult> failedResults, boolean error, String message) {
        this.failedResults = failedResults;
        this.error = error;
        this.message = message;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ValidationErrorType getErrorType() {
        return ValidationErrorType.MULTIPLE;
    }

    @Override
    public List<ValidationResult> getFailedValidationResults() {
        return this.failedResults;
    }
}

