/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.mvel2.compiler.BlankLiteral;
import org.mule.runtime.api.i18n.I18nMessage;

public class NotEmptyValidator
extends AbstractValidator {
    private final Object value;
    private I18nMessage errorMessage;

    public NotEmptyValidator(Object value, ValidationContext validationContext) {
        super(validationContext);
        this.value = value;
    }

    @Override
    public ValidationResult validate() {
        if (this.value == null) {
            this.errorMessage = this.getMessages().valueIsNull();
            return this.fail();
        }
        if (this.value instanceof String) {
            if (StringUtils.isBlank((String)((String)this.value))) {
                this.errorMessage = this.getMessages().stringIsBlank();
                return this.fail();
            }
        } else if (this.value instanceof Collection) {
            if (((Collection)this.value).isEmpty()) {
                this.errorMessage = this.getMessages().collectionIsEmpty();
                return this.fail();
            }
        } else if (this.value instanceof Map) {
            if (((Map)this.value).isEmpty()) {
                this.errorMessage = this.getMessages().mapIsEmpty();
                return this.fail();
            }
        } else if (this.value.getClass().isArray()) {
            if (ArrayUtils.getLength((Object)this.value) == 0) {
                this.errorMessage = this.getMessages().arrayIsEmpty();
                return this.fail();
            }
        } else {
            if (this.value instanceof BlankLiteral) {
                this.errorMessage = this.getMessages().valueIsBlankLiteral();
                return this.fail();
            }
            throw new IllegalArgumentException(String.format("Only instances of Map, Collection, Array and String can be checked for emptyness. Instance of %s was found instead", this.value.getClass().getName()));
        }
        return ImmutableValidationResult.ok();
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.errorMessage;
    }
}

