/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal;

import org.mule.extension.validation.api.ValidationExtension;
import org.mule.extension.validation.api.ValidationOptions;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.ValidationSupport;
import org.mule.extension.validation.internal.validator.BooleanValidator;
import org.mule.extension.validation.internal.validator.EmailValidator;
import org.mule.extension.validation.internal.validator.EmptyValidator;
import org.mule.extension.validation.internal.validator.IpValidator;
import org.mule.extension.validation.internal.validator.MatchesRegexValidator;
import org.mule.extension.validation.internal.validator.NotEmptyValidator;
import org.mule.extension.validation.internal.validator.NotNullValidator;
import org.mule.extension.validation.internal.validator.NullValidator;
import org.mule.extension.validation.internal.validator.SizeValidator;
import org.mule.extension.validation.internal.validator.TimeValidator;
import org.mule.extension.validation.internal.validator.UrlValidator;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

public final class CommonValidationOperations
extends ValidationSupport {
    public void isTrue(boolean expression, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new BooleanValidator(expression, true, context), context);
    }

    public void isFalse(boolean expression, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new BooleanValidator(expression, false, context), context);
    }

    public void isEmail(String email, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new EmailValidator(email, context), context);
    }

    @DisplayName(value="Is IP")
    public void isIp(String ip, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new IpValidator(ip, context), context);
    }

    public void validateSize(Object value, @Optional(defaultValue="0") int min, @Optional Integer max, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new SizeValidator(value, min, max, context), context);
    }

    public void isNotEmpty(Object value, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new NotEmptyValidator(value, context), context);
    }

    public void isEmpty(Object value, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new EmptyValidator(value, context), context);
    }

    public void isNotNull(Object value, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new NotNullValidator(value, context), context);
    }

    public void isNull(Object value, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new NullValidator(value, context), context);
    }

    public void isTime(String time, @Optional String locale, @Optional String pattern, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new TimeValidator(time, this.nullSafeLocale(locale), pattern, context), context);
    }

    @DisplayName(value="Is URL")
    public void isUrl(@DisplayName(value="URL") String url, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new UrlValidator(url, context), context);
    }

    public void matchesRegex(String value, String regex, @Optional(defaultValue="true") boolean caseSensitive, @ParameterGroup(name="Error options") ValidationOptions options, @Config ValidationExtension config) throws Exception {
        ValidationContext context = this.createContext(options, config);
        this.validateWith(new MatchesRegexValidator(value, regex, caseSensitive, context), context);
    }

    private String nullSafeLocale(String locale) {
        return locale == null ? ValidationExtension.DEFAULT_LOCALE : locale;
    }
}

