/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.validation.internal.validator;

import org.mule.extension.validation.api.ValidationResult;
import org.mule.extension.validation.internal.ImmutableValidationResult;
import org.mule.extension.validation.internal.ValidationContext;
import org.mule.extension.validation.internal.validator.AbstractValidator;
import org.mule.runtime.api.i18n.I18nMessage;

public class BooleanValidator
extends AbstractValidator {
    private final boolean value;
    private final boolean expected;

    public BooleanValidator(boolean value, boolean expected, ValidationContext validationContext) {
        super(validationContext);
        this.value = value;
        this.expected = expected;
    }

    @Override
    public ValidationResult validate() {
        return this.value == this.expected ? ImmutableValidationResult.ok() : this.fail();
    }

    @Override
    protected I18nMessage getDefaultErrorMessage() {
        return this.getMessages().failedBooleanValidation(this.value, this.expected);
    }
}

