/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.datamapper.hl7;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.FileLocator;
import org.mule.tooling.datamapper.hl7.Activator;
import org.mule.tooling.datamapper.hl7.HL7MessageType;
import org.mule.tooling.datamapper.hl7.HL7TriggerEvent;
import org.mule.tooling.datamapper.hl7.HL7Version;
import org.osgi.framework.Bundle;

public class HL7VersionProvider {
    private List<HL7Version> versions;

    public List<HL7Version> getVersions() {
        this.load();
        return this.versions;
    }

    public void load() {
        try {
            this.versions = new ArrayList<HL7Version>();
            Bundle bundle = Activator.getDefault().getBundle();
            String location = FileLocator.getBundleFile((Bundle)bundle).getAbsoluteFile().getAbsolutePath();
            File schemas = new File(location, "hl7schemas");
            File[] listFiles = schemas.listFiles();
            if (listFiles == null) {
                throw new RuntimeException("No schemas found at " + location);
            }
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File[] versionSchemas;
                File version = fileArray[n2];
                HashMap<String, HL7MessageType> events = new HashMap<String, HL7MessageType>();
                File[] fileArray2 = versionSchemas = version.listFiles();
                int n3 = versionSchemas.length;
                int n4 = 0;
                while (n4 < n3) {
                    File versionSchema = fileArray2[n4];
                    String name = FilenameUtils.getBaseName((String)versionSchema.getName());
                    if (name.contains("_")) {
                        String[] pattern = name.split("_");
                        String eventName = pattern[0];
                        if (!events.containsKey(eventName)) {
                            events.put(eventName, new HL7MessageType(eventName, new ArrayList<HL7TriggerEvent>()));
                        }
                        ((HL7MessageType)events.get(eventName)).getEvents().add(new HL7TriggerEvent(pattern[1], versionSchema));
                    }
                    ++n4;
                }
                this.versions.add(new HL7Version(version.getName(), new ArrayList<HL7MessageType>(events.values())));
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load HL7 Schemas", e);
        }
    }
}

