/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.datamapper.hl7;

import com.cloveretl.gui.model.GraphMetadata;
import com.mulesoft.mule.datamapper.ui.graph.IMappingFormatProperties;
import com.mulesoft.mule.datamapper.ui.graph.impl.Encoding;
import com.mulesoft.mule.datamapper.ui.graph.impl.XMLFormatInputProperties;
import com.mulesoft.mule.datamapper.ui.graph.impl.XMLFormatOutputProperties;
import com.mulesoft.mule.datamapper.ui.utils.WidgetUtils;
import com.mulesoft.mule.datamapper.ui.wizard.IMetadataFactoryAccessor;
import com.mulesoft.mule.datamapper.ui.wizard.IMetadataFormatPropertiesPanel;
import com.mulesoft.mule.datamapper.ui.wizard.IOpositeMetadataFormatPropertiesPanelAccessor;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.datamapper.hl7.HL7MessageType;
import org.mule.tooling.datamapper.hl7.HL7TriggerEvent;
import org.mule.tooling.datamapper.hl7.HL7Version;
import org.mule.tooling.datamapper.hl7.HL7VersionProvider;
import org.mule.tooling.metadata.utils.XmlSchemaUtils;
import org.mule.tooling.utils.SilentRunner;

public class HL7MetadataFormatPropertiesPanel
extends Composite
implements IMetadataFormatPropertiesPanel {
    private ComboViewer versions;
    private ComboViewer messageType;
    private ComboViewer triggerEvent;
    private ISelectionChangedListener changeListener;
    private HL7VersionProvider hl7VersionProvider;
    private IMetadataFactoryAccessor metadataFactoryAccessor;
    private HL7TriggerEvent selectedEvent;

    public HL7MetadataFormatPropertiesPanel(Composite parent, int style, IMetadataFactoryAccessor metadataFactoryAccessor) {
        super(parent, style);
        this.metadataFactoryAccessor = metadataFactoryAccessor;
        this.setLayout((Layout)new GridLayout(2, false));
        this.hl7VersionProvider = new HL7VersionProvider();
        this.createControl(this);
    }

    protected void createControl(Composite parent) {
        List<HL7Version> versionsList = this.hl7VersionProvider.getVersions();
        Collections.sort(versionsList, new Comparator<HL7Version>(){

            @Override
            public int compare(HL7Version o1, HL7Version o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        Combo versionsCombo = (Combo)new WidgetUtils().createComponentWithLabel(Combo.class, parent, "Version", null, 8);
        this.versions = new ComboViewer(versionsCombo);
        this.versions.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.versions.setInput(versionsList);
        Combo messageTypeCombo = (Combo)new WidgetUtils().createComponentWithLabel(Combo.class, parent, "Message Type", null, 8);
        this.messageType = new ComboViewer(messageTypeCombo);
        this.messageType.setContentProvider((IContentProvider)new ArrayContentProvider());
        Combo triggerEventCombo = (Combo)new WidgetUtils().createComponentWithLabel(Combo.class, parent, "Trigger Event", null, 8);
        this.triggerEvent = new ComboViewer(triggerEventCombo);
        this.triggerEvent.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                if (structuredSelection.isEmpty()) {
                    HL7MetadataFormatPropertiesPanel.this.selectedEvent = null;
                } else {
                    HL7MetadataFormatPropertiesPanel.this.selectedEvent = (HL7TriggerEvent)structuredSelection.getFirstElement();
                }
            }
        });
        this.triggerEvent.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.versions.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection versionSelection = (IStructuredSelection)HL7MetadataFormatPropertiesPanel.this.versions.getSelection();
                if (!versionSelection.isEmpty()) {
                    HL7Version firstElement = (HL7Version)versionSelection.getFirstElement();
                    List<HL7MessageType> types = firstElement.getTypes();
                    Collections.sort(types, new Comparator<HL7MessageType>(){

                        @Override
                        public int compare(HL7MessageType o1, HL7MessageType o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    HL7MetadataFormatPropertiesPanel.this.messageType.setInput(types);
                    HL7MetadataFormatPropertiesPanel.this.triggerEvent.setInput(null);
                } else {
                    HL7MetadataFormatPropertiesPanel.this.messageType.setInput(null);
                    HL7MetadataFormatPropertiesPanel.this.triggerEvent.setInput(null);
                }
            }
        });
        this.messageType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection versionSelection = (IStructuredSelection)HL7MetadataFormatPropertiesPanel.this.messageType.getSelection();
                if (!versionSelection.isEmpty()) {
                    HL7MessageType firstElement = (HL7MessageType)versionSelection.getFirstElement();
                    List<HL7TriggerEvent> events = firstElement.getEvents();
                    Collections.sort(events, new Comparator<HL7TriggerEvent>(){

                        @Override
                        public int compare(HL7TriggerEvent o1, HL7TriggerEvent o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    HL7MetadataFormatPropertiesPanel.this.triggerEvent.setInput(events);
                } else {
                    HL7MetadataFormatPropertiesPanel.this.triggerEvent.setInput(null);
                }
            }
        });
    }

    public List<GraphMetadata> generateMetadata(final IProgressMonitor progressMonitor) {
        HL7TriggerEvent selectedEvent = this.getSelectedTriggerEvent();
        final File schemaFile = selectedEvent.getSchema();
        String schemaPath = schemaFile.getAbsolutePath();
        final String rootElementName = FilenameUtils.getBaseName((String)schemaPath);
        return (List)SilentRunner.run((Callable)new Callable<List<GraphMetadata>>(){

            @Override
            public List<GraphMetadata> call() throws Exception {
                SchemaGlobalElement[] globalElements;
                SchemaGlobalElement[] schemaGlobalElementArray = globalElements = XmlSchemaUtils.getSchemaTypeSystem((URL[])new URL[]{schemaFile.toURI().toURL()}).globalElements();
                int n = globalElements.length;
                int n2 = 0;
                while (n2 < n) {
                    SchemaGlobalElement schemaGlobalElement = schemaGlobalElementArray[n2];
                    if (schemaGlobalElement.getName().getLocalPart().equals(rootElementName)) {
                        return HL7MetadataFormatPropertiesPanel.this.metadataFactoryAccessor.getMetadataFactory().createXMLMetadata(globalElements, schemaGlobalElement, progressMonitor, null);
                    }
                    ++n2;
                }
                return null;
            }
        }, Collections.emptyList());
    }

    private HL7TriggerEvent getSelectedTriggerEvent() {
        return this.selectedEvent;
    }

    public boolean isComplete() {
        return !this.versions.getSelection().isEmpty() && !this.messageType.getSelection().isEmpty() && !this.triggerEvent.getSelection().isEmpty();
    }

    public void setModifyListener(final ModifyListener listener) {
        this.changeListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                listener.modifyText(null);
            }
        };
        this.versions.addSelectionChangedListener(this.changeListener);
        this.messageType.addSelectionChangedListener(this.changeListener);
        this.triggerEvent.addSelectionChangedListener(this.changeListener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.versions.removeSelectionChangedListener(this.changeListener);
        this.messageType.removeSelectionChangedListener(this.changeListener);
        this.triggerEvent.removeSelectionChangedListener(this.changeListener);
    }

    public void setReaderProperties(IMappingFormatProperties info) {
        String absolutePath;
        XMLFormatInputProperties readerInfo = (XMLFormatInputProperties)info;
        String xmlSchemaFilePath = absolutePath = this.getSelectedTriggerEvent().getSchema().getAbsolutePath();
        readerInfo.setXmlSchema(xmlSchemaFilePath);
        readerInfo.setEncoding(Encoding.getDefault());
    }

    public void setWriterProperties(IMappingFormatProperties info) {
        String absolutePath;
        XMLFormatOutputProperties writerInfo = (XMLFormatOutputProperties)info;
        String xmlSchemaFilePath = absolutePath = this.getSelectedTriggerEvent().getSchema().getAbsolutePath();
        writerInfo.setXmlSchema(xmlSchemaFilePath);
        writerInfo.setEncoding(Encoding.getDefault());
    }

    public String getMetadataName() {
        return "HL7";
    }

    public String getSampleAbsoluteFilePath() {
        return null;
    }

    public void setOpositeEditorAccessor(IOpositeMetadataFormatPropertiesPanelAccessor accessor) {
    }

    public void beforeGenerateMetadata() {
    }
}

