/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.test.internal;

import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.mule.extension.test.internal.stream.StreamConsumer;
import org.mule.extension.test.internal.stream.StreamProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

public class TestOperations
implements Initialisable,
Disposable {
    private StreamProvider provider = new StreamProvider();
    private StreamConsumer consumer = new StreamConsumer();
    private ScheduledExecutorService executorService;

    public void initialise() {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void dummy() {
    }

    @Execution(value=ExecutionType.CPU_LITE)
    @MediaType(value="application/octet-stream")
    public InputStream provideStream(int size) {
        return this.provider.get(size);
    }

    @Execution(value=ExecutionType.BLOCKING)
    @MediaType(value="application/octet-stream")
    public byte[] consumeStream(@Content(primary=true) InputStream stream, @Optional(defaultValue="false") boolean chunked, @Optional(defaultValue="1024") int chunkSize) throws MuleException {
        return this.consumer.consume(stream, chunked, chunkSize);
    }

    @Execution(value=ExecutionType.BLOCKING)
    public void blockingDummy(@Optional(defaultValue="0") int delay) {
        if (delay != 0) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    public void cpuTimedDummy(CompletionCallback<Void, Void> callback, @Optional(defaultValue="0") int delay) {
        Runnable task = () -> callback.success(Result.builder().build());
        this.executorService.schedule(task, (long)delay, TimeUnit.MILLISECONDS);
    }

    @Execution(value=ExecutionType.CPU_LITE)
    public void cpuLiteDummy() {
    }

    @Execution(value=ExecutionType.CPU_LITE)
    public void cpuLiteAsyncDummy(CompletionCallback<Void, Void> callback) {
        callback.success(null);
    }

    @Execution(value=ExecutionType.CPU_INTENSIVE)
    public void cpuIntensiveDummy() {
    }

    public void expressionDummy(String name) {
    }

    public String setPayload(String value) {
        return value;
    }

    public void emptyBodyVoidReturnMultiMapParameter(@Content MultiMap<String, String> contentMultiMapParameter) {
    }

    public MultiMap<String, String> multiMapParameterReturn(@Content MultiMap<String, String> contentMultiMapParameter) {
        return contentMultiMapParameter;
    }

    public Result<String, String> resultReturnMultiMapParameter(@Content MultiMap<String, String> contentMultiMapParameter) {
        return Result.builder().build();
    }

    public Result<String, String> resultReturnMultiMapContentParameterMultiMapContentPrimaryParameter(@Content(primary=true) MultiMap<String, String> contentPrimaryMultiMapParameter, @Content MultiMap<String, String> contentMultiMapParameter) {
        return Result.builder().build();
    }

    public Result<String, String> resultReturnMultiMapContentParameterMultiMapContentOptionalParameter(@Optional(defaultValue="#[payload]") MultiMap<String, String> optionalMultiMapParameter, @Content MultiMap<String, String> contentMultiMapParameter) {
        return Result.builder().build();
    }

    public void dispose() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }
}

