/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.test.internal.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamConsumer {
    private static final Logger logger = LoggerFactory.getLogger(StreamConsumer.class);

    public byte[] consume(InputStream stream, boolean chunked, int chunkSize) throws MuleException {
        byte[] result = new byte[]{};
        try {
            if (chunked) {
                byte[] bytes = new byte[chunkSize];
                int read = 0;
                int prevRead = 0;
                while (read != -1) {
                    prevRead = read;
                    read = stream.read(bytes);
                }
                if (prevRead > 0) {
                    result = Arrays.copyOfRange(bytes, 0, prevRead);
                }
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copyLarge((InputStream)stream, (OutputStream)byteArrayOutputStream);
                result = byteArrayOutputStream.toByteArray();
            }
        }
        catch (IOException e) {
            throw new DefaultMuleException("Error attempting to consume payload: " + e.getMessage());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.warn("Failure closing stream: " + e.getMessage());
            }
        }
        return result;
    }
}

