/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.test.internal.stream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class StreamProvider {
    public static final int END = -1;
    public static final String SIXTEEN_BYTES = "1234567890-=+*^,";
    public static final String BYTES_PART = StringUtils.repeat((String)"1234567890-=+*^,", (int)8);
    public static final byte[] BYTES = StringUtils.repeat((String)BYTES_PART, (int)8).getBytes(StandardCharsets.UTF_8);

    public InputStream get(int size) {
        return new SizedStream(size);
    }

    private class SizedStream
    extends InputStream {
        private int read = 0;
        private int size;

        public SizedStream(int size) {
            this.size = size;
        }

        @Override
        public int read() throws IOException {
            if (this.read == this.size) {
                return -1;
            }
            ++this.read;
            return 42;
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.read == this.size) {
                return -1;
            }
            int toRead = Math.min(this.size - this.read, Math.min(b.length, BYTES.length));
            this.read += toRead;
            System.arraycopy(BYTES, 0, b, 0, toRead);
            return toRead;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.read == this.size) {
                return -1;
            }
            int toRead = Math.min(this.size - this.read, Math.min(len, Math.min(b.length, BYTES.length)));
            this.read += toRead;
            System.arraycopy(BYTES, 0, b, off, toRead);
            return toRead;
        }
    }
}

