/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.internal.metadata;

import java.net.URL;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.module.soapkit.internal.OperationFaultPair;
import org.mule.module.soapkit.internal.SoapkitConfiguration;
import org.mule.module.soapkit.internal.WsdlConnectionInfo;
import org.mule.module.soapkit.internal.metadata.AbstractBaseResolver;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.soap.api.SoapVersion;
import org.mule.wsdl.parser.model.FaultModel;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.operation.OperationModel;

public class OperationFaultPairResolver
extends AbstractBaseResolver
implements TypeKeysResolver,
InputTypeResolver<OperationFaultPair>,
OutputTypeResolver<OperationFaultPair> {
    public static final String GENERIC_SF = "GenericSF";
    private static final String GENERIC_SF_LABEL = "Generic Soap Fault";
    private static final String FAULT = "fault";

    public String getResolverName() {
        return "OperationFaultPairResolver";
    }

    public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
        SoapkitConfiguration config = (SoapkitConfiguration)metadataContext.getConfig().orElseThrow(() -> new MetadataResolvingException("Could not obtain config to retrieve metadata", FailureCode.CONNECTION_FAILURE));
        WsdlConnectionInfo info = config.getInfo();
        PortModel portModel = info.getPortModel();
        SoapVersion soapVersion = config.getSoapVersion(portModel);
        HashSet<MetadataKey> keys = new HashSet<MetadataKey>();
        portModel.getOperations().forEach(operation -> {
            MetadataKeyBuilder builder = MetadataKeyBuilder.newKey((String)operation.getName());
            operation.getFaults().forEach(fault -> builder.withChild(MetadataKeyBuilder.newKey((String)fault.getName())));
            builder.withChild(MetadataKeyBuilder.newKey((String)GENERIC_SF).withDisplayName("Generic Soap Fault " + soapVersion));
            keys.add(builder.build());
        });
        return keys;
    }

    public MetadataType getOutputType(MetadataContext ctx, OperationFaultPair key) throws MetadataResolvingException, ConnectionException {
        return this.getMetadataType(ctx, key);
    }

    public MetadataType getInputMetadata(MetadataContext ctx, OperationFaultPair key) throws MetadataResolvingException, ConnectionException {
        return this.getMetadataType(ctx, key);
    }

    private MetadataType getMetadataType(MetadataContext ctx, OperationFaultPair key) throws MetadataResolvingException, ConnectionException {
        Optional metadataType;
        SoapkitConfiguration config = (SoapkitConfiguration)ctx.getConfig().orElseThrow(() -> new MetadataResolvingException("Could not obtain config to retrieve metadata", FailureCode.CONNECTION_FAILURE));
        WsdlConnectionInfo info = config.getInfo();
        PortModel portModel = info.getPortModel();
        SoapVersion soapVersion = config.getSoapVersion(portModel);
        String fault = key.getFault();
        if (GENERIC_SF.equals(fault)) {
            String schema = SoapVersion.SOAP11.equals((Object)soapVersion) ? "sf-v11.xsd" : "sf-v12.xsd";
            URL schemaUrl = OperationFaultPairResolver.getSchemaUrl(schema);
            if (schemaUrl == null) {
                throw new MetadataResolvingException(String.format("Could not obtain schema '%s' for operation='%s', fault='%s'", schema, key.getOperation(), key.getFault()), FailureCode.RESOURCE_UNAVAILABLE);
            }
            SchemaCollector collector = SchemaCollector.getInstance().addSchema(schemaUrl);
            XmlTypeLoader typeLoader = new XmlTypeLoader(collector);
            metadataType = typeLoader.load(FAULT);
        } else {
            try {
                OperationModel operationModel = portModel.getOperation(key.getOperation());
                FaultModel faultModel = operationModel.getFault(fault);
                if (faultModel.getMessage() == null || faultModel.getMessage().getQName() == null) {
                    throw new MetadataResolvingException(String.format("Could not obtain fault Metadata, missing QName for operation='%s', fault='%s'", key.getOperation(), key.getFault()), FailureCode.INVALID_METADATA_KEY);
                }
                QName qName = faultModel.getMessage().getQName();
                metadataType = info.getXmlTypeLoader().load(qName.toString());
            }
            catch (Exception e) {
                throw new MetadataResolvingException(String.format("Could not obtain fault Metadata for operation='%s', fault='%s'", key.getOperation(), key.getFault()), FailureCode.INVALID_METADATA_KEY, (Throwable)e);
            }
        }
        return (MetadataType)metadataType.orElseThrow(() -> new MetadataResolvingException(String.format("Could not obtain fault Metadata for operation='%s', fault='%s'", key.getOperation(), key.getFault()), FailureCode.INVALID_METADATA_KEY));
    }
}

