/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.module.soapkit.metadata;

import java.util.Set;
import java.util.function.BiConsumer;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

import static java.util.stream.Collectors.joining;
import static org.hamcrest.CoreMatchers.hasItems;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.core.Is.is;
import static org.mule.runtime.api.component.location.Location.builder;
import static org.mule.runtime.api.metadata.MetadataKeyBuilder.newKey;
import static org.mule.tck.junit4.matcher.MetadataKeyMatcher.metadataKeyWithId;

public class OperationFaultPairTestCase extends AbstractMetadataTestCase {

  private static final String LIST_INVENTORY_FLOW = "ListInventory:\\config";
  private static final Location LIST_INVENTORY_LOCATION =
      builder().globalName(LIST_INVENTORY_FLOW).addProcessorsPart().addIndexPart(0).build();

  public OperationFaultPairTestCase(final ResolutionType resolutionType) {
    super(resolutionType);
  }

  @Override
  protected String getConfigFile() {
    return "soapkit-metadata.xml";
  }

  @Test
  public void operationFaultPairKeys() throws Exception {

    final MetadataResult<MetadataKeysContainer> metadataResult = metadataService.getMetadataKeys(LIST_INVENTORY_LOCATION);
    assertSuccessMetadataResult(metadataResult);
    final Set<MetadataKey> metadataKeys = getKeySetFromContainer(metadataResult.get());
    assertThat(metadataKeys.size(), is(3));
    assertThat(metadataKeys,

               hasItems(metadataKeyWithId("ListInventory"), metadataKeyWithId("TrackOrder"), metadataKeyWithId("OrderTshirt")));

    final Set<MetadataKey> faults = metadataKeys.iterator().next().getChilds();
    assertThat(faults, hasSize(2));

    assertThat(faults, hasItem(metadataKeyWithId("TshirtFault").withDisplayName("TshirtFault").withPartName("fault")));
    assertThat(faults,
               hasItem(metadataKeyWithId("GenericSF").withDisplayName("Generic Soap Fault SOAP11").withPartName("fault")));
  }

  @Ignore
  public void operationFaultPairEntityMetadata() throws Exception {

    final MetadataKey key = newKey("ListInventory").withChild(newKey("TshirtFault")).build();

    final MetadataResult<TypeMetadataDescriptor> metadataResult =
        metadataService.getEntityMetadata(LIST_INVENTORY_LOCATION, key);
    assertSuccessMetadataResult(metadataResult);
    assertThat(metadataResult.isSuccess(), Matchers.is(true));
    final TypeMetadataDescriptor descriptor = metadataResult.get();
    //      System.out.println("OperationFaultPairTestCase.operationFaultPairMetadata");
  }

  @Ignore
  public void outputAndMultipleInputWithKey() throws Exception {

    final MetadataKey key = newKey("ListInventory").withChild(newKey("TshirtFault")).build();
    final ComponentMetadataDescriptor<OperationModel> metadataDescriptor =
        getSuccessComponentDynamicMetadataWithKey(LIST_INVENTORY_LOCATION, key);

    final OperationModel typedModel = metadataDescriptor.getModel();
    //assertExpectedType(getParameter(typedModel, "type"), String.class);
    //assertExpectedType(getParameter(typedModel, "firstPerson"), personType, true);
    //assertExpectedType(getParameter(typedModel, "otherPerson"), personType, true);

    System.out.println("OperationFaultPairTestCase.operationFaultPairMetadata");

  }
}
