/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.module.soapkit.metadata;

import java.util.Map;
import java.util.Set;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.module.soapkit.internal.metadata.AbstractBaseResolver;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.api.component.location.Location.builder;

public class ConfigKeysTestCase extends AbstractMetadataTestCase {


  public ConfigKeysTestCase(final ResolutionType resolutionType) {
    super(resolutionType);
  }

  @Override
  protected String getConfigFile() {
    return "soapkit-metadata.xml";
  }

  @Test
  public void getMetadataKeysForConfig() throws Exception {
    final MetadataResult<MetadataKeysContainer> metadataKeysResult =
        metadataService.getMetadataKeys(builder().globalName("config").build());
    assertThat(metadataKeysResult.isSuccess(), is(true));
    final Map<String, Set<MetadataKey>> metadataKeys = getKeyMapFromContainer(metadataKeysResult.get());
    assertThat(metadataKeys.size(), is(1));
    assertThat(metadataKeys.get(AbstractBaseResolver.SOAPKIT_CATEGORY).size(), is(3));
  }

  @Ignore
  public void getMetadataKeysForConfigWithRemoteWsdl() throws Exception {
    final MetadataResult<MetadataKeysContainer> metadataKeysResult =
        metadataService.getMetadataKeys(builder().globalName("config-remote").build());
    assertThat(metadataKeysResult.isSuccess(), is(true));
    final Map<String, Set<MetadataKey>> metadataKeys = getKeyMapFromContainer(metadataKeysResult.get());
    assertThat(metadataKeys.size(), is(1));
    assertThat(metadataKeys.get(AbstractBaseResolver.SOAPKIT_CATEGORY).size(), is(2));
  }

}
