/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.module.soapkit;

import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.module.soapkit.internal.WsdlConnectionInfo;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;

import static junit.framework.TestCase.fail;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.notNullValue;

public class WsdlConnectionInfoTestCase {

  private static final String LOCAL_WSDL_LOCATION = "api/tshirt.wsdl";
  private static final String REMOTE_WSDL_LOCATION = "http://www.webservicex.com/globalweather.asmx?WSDL";

  @Rule
  public final ExpectedException exception = ExpectedException.none();

  @Test
  public void wsdlWithoutNamespace() {
    assertWsdlConnectionInfo("api/addressValidationService.wsdl", "AddressService", "BasicHttpBinding_AddressValidationService");
  }

  @Test
  public void wsdlCorrupted() throws ConnectionException {
    final WsdlConnectionInfo info = new WsdlConnectionInfo();
    info.setWsdlLocation("corrupted.wsdl");
    exception.expect(ConnectionException.class);
    info.getWsdlModel();
  }

  @Test
  public void withLocalWsdl() {
    assertWsdlConnectionInfo(LOCAL_WSDL_LOCATION, "TshirtService", "TshirtServicePort");
  }

  @Ignore
  public void withRemoteWsdl() {
    assertWsdlConnectionInfo(REMOTE_WSDL_LOCATION, "GlobalWeather", "GlobalWeatherSoap");
  }

  private static void assertWsdlConnectionInfo(final String location, final String service, final String port) {
    final WsdlConnectionInfo info = new WsdlConnectionInfo();
    info.setWsdlLocation(location);

    try {
      final WsdlModel wsdlModel = info.getWsdlModel();
      assertThat(wsdlModel, notNullValue());

      info.setService(service);
      final ServiceModel serviceModel = info.getServiceModel();
      assertThat(serviceModel, notNullValue());

      info.setPort(port);
      final PortModel portModel = info.getPortModel();
      assertThat(portModel, notNullValue());

    } catch (ConnectionException e) {
      fail(e.getMessage());
    }
  }

}
