/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.soapkit.internal.metadata;

import java.net.URL;
import org.mule.module.soapkit.internal.SoapkitOperations;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;

import static java.lang.Thread.currentThread;

/**
 * Base class for all metadata resolvers of the {@link SoapkitOperations}.
 *
 * @since 1.1.2
 */
public abstract class AbstractBaseResolver {

  static final String SF_V11_XSD = "sf-v11.xsd";
  static final String SF_V12_XSD = "sf-v12.xsd";

  public static final String SOAPKIT_CATEGORY = "SoapkitResolverCategory";

  public String getCategoryName() {
    return SOAPKIT_CATEGORY;
  }

  protected static URL getSchemaUrl(final String schema) {
    return currentThread().getContextClassLoader().getResource(schema);
  }
}
