/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.module.soapkit.internal.exception.error;

import org.mule.module.soapkit.internal.exception.SoapkitFaultException;
import org.mule.module.soapkit.internal.exception.SoapkitRouterException;
import org.mule.runtime.extension.api.exception.ModuleException;

public class SoapkitExceptionEnricher {

  public SoapkitExceptionEnricher() {}

  public Exception enrich(final Exception e) {
    if (e instanceof SoapkitRouterException) {
      return new ModuleException(SoapkitErrors.ROUTER, e);
    }
    if (e instanceof SoapkitFaultException) {
      return new ModuleException(SoapkitErrors.FAULT, e);
    }
    return e;
  }
}
