/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.module.soapkit.internal.exception.error;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.mule.module.soapkit.internal.SoapkitOperations;
import org.mule.module.soapkit.internal.exception.error.SoapkitErrors;
import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

/**
 * {@link ErrorTypeProvider} implementation for the {@link SoapkitOperations router}.
 *
 * @since 1.1
 */
public class SoapkitErrorTypeProvider implements ErrorTypeProvider {

  /**
   * @return all the error types that can be thrown by the {@link SoapkitOperations router}.
   */
  @Override
  public Set<ErrorTypeDefinition> getErrorTypes() {
    return ImmutableSet.<ErrorTypeDefinition>builder()
        .add(SoapkitErrors.ROUTER)
        .add(SoapkitErrors.FAULT)
        .build();
  }
}
