/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.module.soapkit.internal;

import org.mule.module.soapkit.internal.exception.error.SoapkitErrorTypeProvider;
import org.mule.module.soapkit.internal.metadata.OperationFaultPairResolver;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.extension.api.soap.SoapAttributes;

import java.io.InputStream;
import java.util.Map;

import static org.mule.runtime.extension.api.annotation.param.Optional.PAYLOAD;

public class SoapkitOperations {

  @Config
  SoapkitConfiguration configuration;

  /**
  * APIKit for SOAP Router
  */
  @MediaType(value = MediaType.ANY, strict = false)
  @OnException(SoapkitExceptionHandler.class)
  @Throws(SoapkitErrorTypeProvider.class)
  @DisplayName("SOAP Router")
  @Execution(ExecutionType.BLOCKING)
  public Result<InputStream, SoapAttributes> router(@Config SoapkitConfiguration config,
                                                    @Content(primary = true) InputStream message,
                                                    @Content Map<String, Object> attributes,
                                                    StreamingHelper helper) {

    // This is resolved by a SoapkitRouterExecutor
    return null;
  }

  /**
   * APIKit for SOAP Fault
   */
  @MediaType(value = MediaType.APPLICATION_XML)
  @DisplayName("SOAP Fault")
  @OnException(SoapkitExceptionHandler.class)
  @Throws(SoapkitErrorTypeProvider.class)
  @OutputResolver(output = OperationFaultPairResolver.class)
  public InputStream fault(@Config SoapkitConfiguration config,
                           @TypeResolver(OperationFaultPairResolver.class) @Optional(defaultValue = PAYLOAD) InputStream payload,
                           @ParameterGroup(
                               name = "SOAP Fault Information") @MetadataKeyId(OperationFaultPairResolver.class) OperationFaultPair key) {
    return payload;
  }
}
