/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.module.soapkit.internal;

import org.mule.module.soapkit.internal.exception.error.SoapkitExceptionEnricher;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;

/**
 * {@link ExceptionHandler} implementation to wrap unexpected exceptions thrown by the {@link SoapkitOperations router}.
 *
 * @since 1.1
 */
public class SoapkitExceptionHandler extends ExceptionHandler {

  private final SoapkitExceptionEnricher enricher = new SoapkitExceptionEnricher();

  /**
   * {@inheritDoc}
   */
  @Override
  public Exception enrichException(Exception e) {
    return enricher.enrich(e);
  }
}
