/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.module.soapkit.internal;

import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.property.ComponentExecutorModelProperty;

public class SoapkitDeclarationEnricher implements DeclarationEnricher {

  private static final String ROUTER = "router";

  @Override
  public void enrich(ExtensionLoadingContext extensionLoadingContext) {
    for (ConfigurationDeclaration configuration : extensionLoadingContext.getExtensionDeclarer().getDeclaration()
        .getConfigurations())
      configuration.getOperations().forEach(operation -> {
        if (operation.getName().equals(ROUTER)) {
          operation.addModelProperty(new ComponentExecutorModelProperty((model, params) -> new SoapkitRouterExecutor()));
        }
      });
  }
}
