/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.module.soapkit.internal;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.runtime.api.metadata.TypedValue;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;

public class SoapSubFlowPayload implements Serializable {

  private static final long serialVersionUID = -4728762641020105226L;

  private final TypedValue<InputStream> body;
  private final Map<String, TypedValue<String>> headers;
  private final Map<String, TypedValue<InputStream>> attachments;

  public SoapSubFlowPayload(final TypedValue<InputStream> body, final Map<String, TypedValue<String>> headers,
                            final Map<String, TypedValue<InputStream>> attachments) {
    this.body = body;
    this.headers = headers;
    this.attachments = attachments;
  }

  public TypedValue<InputStream> getBody() {
    return body;
  }

  public Map<String, TypedValue<String>> getHeaders() {
    return headers;
  }

  public Map<String, TypedValue<InputStream>> getAttachments() {
    return attachments;
  }

  @Override
  public String toString() {
    return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
  }

}
