/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.module.soapkit.internal;

import java.util.Collections;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.util.Map;

public class SoapSubFlowAttributes implements Serializable {

  private static final long serialVersionUID = -4728762641020105226L;

  private Map<String, String> protocolHeaders = Collections.emptyMap();

  public SoapSubFlowAttributes() {}

  public SoapSubFlowAttributes(Map<String, String> protocolHeaders) {
    this.protocolHeaders = protocolHeaders;
  }

  @Override
  public String toString() {
    return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
  }

  public Map<String, String> getProtocolHeaders() {
    return protocolHeaders;
  }
}
