/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.soapkit.internal.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.extension.api.runtime.config.ConfiguredComponent;
import org.mule.runtime.extension.api.runtime.source.ParameterizedSource;
import org.mule.soapkit.soap.util.Cast;

public class HttpListenerUtils {
    private static final Logger LOGGER = Logger.getLogger(HttpListenerUtils.class);
    private static final String PATH = "path";
    private static final String BASE_PATH = "basePath";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String PROTOCOL = "protocol";
    private static final String HTTP_LISTENER = "http:listener";

    private HttpListenerUtils() {
    }

    public static URI getUriFromFlow(Component source) {
        if (source != null && HttpListenerUtils.isHttpExtensionSource(source)) {
            try {
                String resolvedPath = HttpListenerUtils.getListenerPath(source);
                return HttpListenerUtils.buildListenerUri(HttpListenerUtils.getConfigState(source).getConnectionParameters(), resolvedPath);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Error getting uri from flow " + source.getLocation().getRootContainerName()), (Throwable)e);
            }
        }
        return null;
    }

    private static String getListenerPath(Component source) {
        ParameterizedSource parameterizedSource = (ParameterizedSource)Cast.cast((Object)source);
        String listenerPath = (String)Cast.cast(parameterizedSource.getInitialisationParameters().get(PATH));
        String basePath = (String)Cast.cast(HttpListenerUtils.getConfigState(source).getConfigParameters().get(BASE_PATH));
        listenerPath = StringUtils.prependIfMissing((String)listenerPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return basePath == null ? listenerPath : StringUtils.prependIfMissing((String)basePath, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + listenerPath;
    }

    private static ConfigurationState getConfigState(Component source) {
        ConfiguredComponent configuredComponent = (ConfiguredComponent)Cast.cast((Object)source);
        return ((ConfigurationInstance)configuredComponent.getConfigurationInstance().orElseThrow(() -> new RuntimeException("Source does not contain a configuration instance"))).getState();
    }

    private static boolean isHttpExtensionSource(Component source) {
        ComponentIdentifier identifier = source.getLocation().getComponentIdentifier().getIdentifier();
        return identifier.equals(ComponentIdentifier.buildFromStringRepresentation((String)HTTP_LISTENER));
    }

    private static URI buildListenerUri(Map<String, Object> connectionParams, String path) throws URISyntaxException {
        String host = (String)Cast.cast((Object)connectionParams.get(HOST));
        Integer port = (Integer)Cast.cast((Object)connectionParams.get(PORT));
        String scheme = connectionParams.get(PROTOCOL).toString().toLowerCase();
        return new URI(scheme, null, host, port, path, null, null);
    }
}

