/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.server.interceptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.annotations.SchemaValidation.SchemaValidationType;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.interceptor.StartBodyInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.ServiceUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.staxutils.validation.WoodstoxValidationImpl;

// Idem from CXF but running in a different phase
public class StaxSchemaValidationInInterceptor extends AbstractPhaseInterceptor<Message> {

  private static final Logger LOG = LogUtils.getL7dLogger(StaxSchemaValidationInInterceptor.class);

  public StaxSchemaValidationInInterceptor() {
    super(Phase.READ);
    addBefore(StartBodyInterceptor.class.getName());
    addAfter(ReadHeadersInterceptor.class.getName());
  }

  public void handleMessage(Message message) throws Fault {
    XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
    setSchemaInMessage(message, xmlReader);
  }

  private void setSchemaInMessage(Message message, XMLStreamReader reader) {
    if (ServiceUtils.isSchemaValidationEnabled(SchemaValidationType.IN, message)) {
      try {
        WoodstoxValidationImpl mgr = new WoodstoxValidationImpl();
        if (mgr.canValidate()) {
          mgr.setupValidation(reader, message.getExchange().getEndpoint(),
                              message.getExchange().getService().getServiceInfos().get(0));
        }
      } catch (Throwable t) {
        //likely no MSV or similar
        LOG.log(Level.FINE, "Problem initializing MSV validation", t);
      }
    }
  }
}
