/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.server;

import java.util.List;
import javax.xml.namespace.QName;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class SoapServerMessages extends I18nMessageFactory {

  private static final SoapServerMessages factory = new SoapServerMessages();

  private static final String BUNDLE_PATH = getBundlePath("soap-server");

  public static I18nMessage invalidOrMissingNamespace(QName serviceQName, List<QName> probableServices, List<QName> allServices) {
    return factory.createMessage(BUNDLE_PATH, 25, String.valueOf(serviceQName), String.valueOf(probableServices),
                                 String.valueOf(allServices));
  }

  public static I18nMessage couldNotFindEndpoint(QName endpointNameThatCannotBeFound, List<QName> availableEndpoingNames) {
    return factory.createMessage(BUNDLE_PATH, 27, String.valueOf(endpointNameThatCannotBeFound),
                                 String.valueOf(availableEndpoingNames));
  }

  protected static String getBundlePath(String bundleName) {
    return "META-INF/org/mule/service/soap/server/" + bundleName + "-messages";
  }
}


