/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.soapkit.soap.api.server;

import org.mule.runtime.api.connection.ConnectionException;

/**
 * A Contract for Factory Objects that creates {@link SoapServer instances}
 *
 * @since 4.1
 */
public interface SoapServerFactory {

  /**
   * Creates a new SoapServer instance.
   *
   * @param configuration the {@link SoapServerConfiguration} specifying the desired server configuration.
   * @return a newly built {@link SoapServer} based on the {@code configuration}.
   */
  SoapServer create(SoapServerConfiguration configuration) throws ConnectionException;
}
