/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.server.interceptor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soapkit.soap.message.SoapResponse;
import org.mule.soapkit.soap.util.Cast;
import org.mule.soapkit.soap.util.XmlTransformationUtils;

public class OutputSoapHeadersInterceptor
extends AbstractSoapInterceptor {
    public OutputSoapHeadersInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        SoapResponse response = (SoapResponse)Cast.cast(message.getExchange().get((Object)"mule.soap.server.response"));
        if (response == null) {
            return;
        }
        message.put(Header.HEADER_LIST, this.transformToCxfHeaders(response.getSoapHeaders()));
    }

    private List<SoapHeader> transformToCxfHeaders(Map<String, String> headers) {
        if (headers == null) {
            return Collections.emptyList();
        }
        return headers.entrySet().stream().map(header -> {
            try {
                return new SoapHeader(new QName(null, (String)header.getKey()), (Object)XmlTransformationUtils.stringToDomElement((String)header.getValue()));
            }
            catch (Exception e) {
                throw new BadRequestException("Cannot parse input header [" + (String)header.getKey() + "]", (Throwable)e);
            }
        }).collect(Collectors.toList());
    }
}

