/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soapkit.soap.api.server;

import java.net.URL;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.mule.soap.api.SoapVersion;
import org.mule.soapkit.soap.api.param.ValidationLevel;
import org.mule.soapkit.soap.api.server.SoapServerConfiguration;
import org.mule.wsdl.parser.WsdlParser;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;

public class SoapServerConfigurationBuilder {
    private URL wsdlLocation;
    private String service;
    private String port;
    private SoapVersion version = null;
    private boolean mtomEnabled;
    private boolean validationEnabled = false;
    private boolean responseXMLDeclarationEnabled = false;
    private ValidationLevel validationLevel;
    private boolean payloadBody = true;
    private Map<String, String> namespaces;

    SoapServerConfigurationBuilder() {
    }

    public SoapServerConfigurationBuilder withService(String service) {
        this.service = service;
        return this;
    }

    public SoapServerConfigurationBuilder withPort(String port) {
        this.port = port;
        return this;
    }

    public SoapServerConfigurationBuilder withVersion(SoapVersion version) {
        this.version = version;
        return this;
    }

    public SoapServerConfigurationBuilder enableMtom(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
        return this;
    }

    public SoapServerConfigurationBuilder enableValidation(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
        return this;
    }

    public SoapServerConfigurationBuilder enableResponseXMLDeclaration(boolean responseXMLDeclarationEnabled) {
        this.responseXMLDeclarationEnabled = responseXMLDeclarationEnabled;
        return this;
    }

    public SoapServerConfigurationBuilder withWsdlLocation(URL wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
        return this;
    }

    public SoapServerConfigurationBuilder withNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public SoapServerConfigurationBuilder withValidationErrorLevel(ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
        return this;
    }

    public SoapServerConfiguration build() {
        Objects.requireNonNull(this.wsdlLocation, "WSDL location cannot be null");
        Objects.requireNonNull(this.service, "Service cannot be null");
        Objects.requireNonNull(this.port, "Port cannot be null");
        WsdlModel wsdlModel = WsdlParser.Companion.parse(this.wsdlLocation.toString());
        ServiceModel serviceModel = wsdlModel.getService(this.service);
        Objects.requireNonNull(serviceModel, String.format("Service '%s' not found in '%s'", this.service, this.wsdlLocation));
        PortModel portModel = serviceModel.getPort(this.port);
        Objects.requireNonNull(portModel, String.format("Port '%s' not found in '%s'", this.port, this.wsdlLocation));
        QName qName = serviceModel.getQName();
        Objects.requireNonNull(qName, String.format("QName not found for Service '%s' in '%s'", this.service, this.wsdlLocation));
        String namespace = qName.getNamespaceURI();
        Objects.requireNonNull(namespace, String.format("Namespace not found for Service '%s' in '%s'", this.service, this.wsdlLocation));
        return new SoapServerConfiguration(wsdlModel, this.wsdlLocation, namespace, serviceModel, portModel, this.version, this.mtomEnabled, this.validationEnabled, this.payloadBody, this.namespaces, this.validationLevel, this.responseXMLDeclarationEnabled);
    }
}

