/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.processors;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.EdmReferentialConstraint;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.search.SearchBinary;
import org.apache.olingo.server.api.uri.queryoption.search.SearchExpression;
import org.apache.olingo.server.core.uri.parser.Parser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.validator.UriValidationException;
import org.mule.extension.api.routing.ListenerRequestAttributes;
import org.mule.extension.api.serialization.CollectionSuccessResponse;
import org.mule.extension.api.serialization.EntityCollectionSuccessResponse;
import org.mule.extension.api.serialization.EntitySuccessResponse;
import org.mule.extension.api.serialization.SuccessResponse;
import org.mule.extension.internal.exception.DeserializationException;
import org.mule.extension.internal.exception.ExpansionException;
import org.mule.extension.internal.handlers.RequestHandler;
import org.mule.extension.internal.processors.FilterExpressionToODataVisitor;
import org.mule.extension.internal.routing.DefaultRoutingContext;
import org.mule.extension.internal.routing.RoutingKey;
import org.mule.extension.internal.routing.RoutingManager;
import org.mule.extension.internal.routing.SourceKind;
import org.mule.extension.internal.sources.ExpansionParameters;
import org.mule.extension.internal.sources.SourceConfiguration;
import org.mule.extension.internal.utils.ObjectMapperFactory;
import org.mule.extension.internal.utils.OlingoUtils;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExpansionProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpansionProcessor.class);
    private final OData oData;
    private final ServiceMetadata serviceMetadata;
    private final RequestHandler entityCollectionRequestHandler;
    private final ObjectMapper objectMapper;
    private final RoutingManager routingManager;
    private final FilterExpressionToODataVisitor filterVisitor = new FilterExpressionToODataVisitor();

    ExpansionProcessor(OData odata, ServiceMetadata serviceMetadata, RequestHandler requestHandler, RoutingManager routingManager) {
        this.oData = odata;
        this.serviceMetadata = serviceMetadata;
        this.entityCollectionRequestHandler = requestHandler;
        this.objectMapper = ObjectMapperFactory.buildJsonObjectMapper();
        this.routingManager = routingManager;
    }

    public CompletableFuture<? extends SuccessResponse> resolveExpansion(ExpansionParameters expansionParameters, SuccessResponse source, ODataRequest parentRequest, UriInfo parentUriInfo) {
        ExpandOption expandOption = parentUriInfo.getExpandOption();
        boolean isCollection = source instanceof CollectionSuccessResponse;
        if (expandOption == null) {
            return CompletableFuture.completedFuture(source);
        }
        try {
            Map result = (Map)this.objectMapper.readValue((InputStream)source.getResponseContent().getValue(), Map.class);
            List entries = isCollection ? (List)result.get("value") : Collections.singletonList(result);
            return this.resolveExpandTree(parentRequest, parentUriInfo, entries, expandOption, expansionParameters, expansionParameters.isIgnoreErrorsOnExpansionEnabled(), expansionParameters.getMaxDepth(), 0).thenApply(v -> {
                try {
                    TypedValue newBody = new TypedValue((Object)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes((Object)result)), source.getResponseContent().getDataType());
                    return isCollection ? new EntityCollectionSuccessResponse((TypedValue<InputStream>)newBody, ((CollectionSuccessResponse)source).getResponseParameters().orElse(null)) : new EntitySuccessResponse((TypedValue<InputStream>)newBody, null);
                }
                catch (IOException e) {
                    throw new ExpansionException("An exception occurred while writing completed expansion response value", e);
                }
            });
        }
        catch (IOException e) {
            throw new DeserializationException("An error occurred while deserializing entity collection", e);
        }
        catch (ODataApplicationException | ExpressionVisitException e) {
            throw new ExpansionException(e);
        }
    }

    private CompletableFuture<Void> resolveExpandTree(ODataRequest request, UriInfo uriInfo, List<Map<String, ?>> entries, ExpandOption expandOption, ExpansionParameters expansionParameters, boolean ignoreErrorsOnExpansionEnabled, Integer maxDepth, Integer depth) throws ODataApplicationException, ExpressionVisitException {
        if (depth >= maxDepth) {
            throw new ExpansionException("Max query depth exceeded");
        }
        EdmEntityType entityType = OlingoUtils.getReturnEntityType(uriInfo).orElseThrow(() -> new ExpansionException(new IllegalStateException("Failed to retrieve entity type from uriInfo")));
        EdmEntitySet entitySet = OlingoUtils.getEntitySet(uriInfo).orElseThrow(() -> new ExpansionException(new IllegalStateException("Failed to retrieve entity set from uriInfo")));
        List expandableProperties = expandOption.getExpandItems().stream().filter(item -> expansionParameters.getExpandableProperties().contains(((UriResource)item.getResourcePath().getUriResourceParts().get(0)).getSegmentValue())).collect(Collectors.toList());
        if (expandableProperties.size() == 0) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture[] completableFutures = new CompletableFuture[expandableProperties.size()];
        for (int index = 0; index < expandableProperties.size(); ++index) {
            completableFutures[index] = this.resolveFieldExpansion(request, (ExpandItem)expandableProperties.get(index), entityType, entitySet, entries, ignoreErrorsOnExpansionEnabled, maxDepth, depth);
        }
        return CompletableFuture.allOf(completableFutures);
    }

    private CompletableFuture<Void> resolveFieldExpansion(ODataRequest parentRequest, ExpandItem expandItem, EdmEntityType parentType, EdmEntitySet parentEntitySet, List<Map<String, ?>> parentEntries, boolean ignoreErrorsOnExpansionEnabled, Integer maxDepth, Integer depth) throws ODataApplicationException, ExpressionVisitException {
        String propertyToExpand = ((UriResource)expandItem.getResourcePath().getUriResourceParts().get(0)).getSegmentValue();
        EdmNavigationPropertyBinding navigationPropertyBinding = parentEntitySet.getNavigationPropertyBindings().stream().filter(binding -> propertyToExpand.equals(binding.getPath())).findFirst().orElseThrow(() -> new ExpansionException("No NavigationPropertyBinding found for " + propertyToExpand));
        EdmNavigationProperty navigationProperty = parentType.getNavigationProperty(propertyToExpand);
        List constraints = navigationProperty.getReferentialConstraints();
        if (constraints.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        HashMap referencedPropertyMap = new HashMap();
        constraints.forEach(con -> referencedPropertyMap.put(con.getPropertyName(), con.getReferencedPropertyName()));
        MultiMap parentEntriesIndex = new MultiMap();
        HashMap<String, Set<String>> mapToFetch = new HashMap<String, Set<String>>();
        parentEntries.forEach(entry -> referencedPropertyMap.forEach((propertyName, referencedPropertyName) -> {
            Object prop = entry.get(propertyName);
            EdmElement elem = parentType.getProperty(propertyName);
            if (prop != null) {
                mapToFetch.computeIfAbsent((String)referencedPropertyName, key -> new HashSet()).add(OlingoUtils.formatODataValue(elem.getType(), prop, elem.isCollection()));
                if (referencedPropertyMap.size() == 1) {
                    parentEntriesIndex.put(prop, entry);
                }
            }
        }));
        ODataRequest childRequest = this.createChildRequest(parentRequest, expandItem, navigationPropertyBinding.getTarget(), mapToFetch);
        UriInfo childUriInfo = this.createChildUriInfo(childRequest);
        DefaultRoutingContext routingContext = (DefaultRoutingContext)this.entityCollectionRequestHandler.handleRequest(childRequest, childUriInfo, SourceKind.ENTITY_COLLECTION);
        RoutingKey<InputStream, ListenerRequestAttributes, SourceConfiguration> childRoutingKey = OlingoUtils.getRoutingKey(childRequest, childUriInfo, SourceKind.ENTITY_COLLECTION);
        ExpansionParameters childExpansionParameters = this.routingManager.getExpansionParametersConfig(childRoutingKey).getExpansionParameters();
        return ((CompletableFuture)routingContext.getFlowCompletableResponse().thenCompose(sourceResponse -> {
            try {
                List resultEntries = (List)((Map)this.objectMapper.readValue((InputStream)sourceResponse.getResponseContent().getValue(), Map.class)).get("value");
                if (resultEntries == null) {
                    return CompletableFuture.completedFuture(null);
                }
                if (referencedPropertyMap.size() > 1) {
                    this.appendChildEntitiesMultipleConstraints(resultEntries, parentEntries, propertyToExpand, navigationProperty, referencedPropertyMap);
                } else {
                    this.appendChildEntities(resultEntries, (MultiMap<Object, Object>)parentEntriesIndex, propertyToExpand, navigationProperty, ((EdmReferentialConstraint)constraints.get(0)).getReferencedPropertyName());
                }
                if (expandItem.getExpandOption() == null) {
                    return CompletableFuture.completedFuture(null);
                }
                if (!sourceResponse.getResponseParameters().isPresent()) {
                    return CompletableFuture.completedFuture(null);
                }
                return this.resolveExpandTree(childRequest, childUriInfo, resultEntries, expandItem.getExpandOption(), childExpansionParameters, ignoreErrorsOnExpansionEnabled, maxDepth, depth + 1);
            }
            catch (Exception e) {
                LOGGER.error(String.format("An exception occurred during expansion of %s", propertyToExpand), (Throwable)e);
                throw new ExpansionException(String.format("An exception occurred while reading response content from flow during expansion of %s", propertyToExpand), e);
            }
        })).exceptionally(ex -> {
            LOGGER.error("An exception occurred during expansion of {}", (Object)propertyToExpand);
            if (!ignoreErrorsOnExpansionEnabled) {
                throw ex instanceof RuntimeException ? (RuntimeException)ex : new ExpansionException((Throwable)ex);
            }
            LOGGER.warn("The error is being omitted and a \"null\" will be placed as a result of the {} collection", (Object)propertyToExpand);
            return null;
        });
    }

    private void appendChildEntities(List<Map<String, ?>> resultEntities, MultiMap<Object, Object> parentEntriesIndex, String propertyToExpand, EdmNavigationProperty navigationProperty, String referencedPropertyName) {
        if (resultEntities == null) {
            return;
        }
        resultEntities.forEach(childEntity -> parentEntriesIndex.getAll(childEntity.get(referencedPropertyName)).forEach(parentEntity -> {
            Map parentMap = (Map)parentEntity;
            if (navigationProperty.isCollection()) {
                parentMap.computeIfAbsent(propertyToExpand, k -> new ArrayList());
                ((List)parentMap.get(propertyToExpand)).add(childEntity);
            } else {
                parentMap.put(propertyToExpand, childEntity);
            }
        }));
    }

    private void appendChildEntitiesMultipleConstraints(List<Map<String, ?>> resultEntities, List<Map<String, ?>> parentEntries, String propertyToExpand, EdmNavigationProperty navigationProperty, Map<String, String> referencedPropertyMap) {
        if (resultEntities == null) {
            return;
        }
        AtomicBoolean match = new AtomicBoolean(true);
        resultEntities.forEach(childEntity -> parentEntries.forEach(parentEntity -> {
            Map parentMap = parentEntity;
            match.set(true);
            referencedPropertyMap.keySet().forEach(propertyName -> {
                if (!parentEntity.get(propertyName).equals(childEntity.get(referencedPropertyMap.get(propertyName)))) {
                    match.set(false);
                }
            });
            if (match.get()) {
                if (navigationProperty.isCollection()) {
                    parentMap.computeIfAbsent(propertyToExpand, k -> new ArrayList());
                    ((List)parentMap.get(propertyToExpand)).add(childEntity);
                } else {
                    parentMap.put(propertyToExpand, childEntity);
                }
            }
        }));
    }

    private ODataRequest createChildRequest(ODataRequest parentRequest, ExpandItem expandItem, String target, HashMap<String, Set<String>> mapToFetch) throws ODataApplicationException, ExpressionVisitException {
        String childFilter = expandItem.getFilterOption() != null ? " and " + ((FilterExpressionToODataVisitor.VisitorContext)expandItem.getFilterOption().getExpression().accept((ExpressionVisitor)this.filterVisitor)).getValue() : "";
        HashSet filterList = new HashSet();
        mapToFetch.forEach((fieldName, values) -> filterList.add(fieldName + " in (" + String.join((CharSequence)",", values) + ")"));
        String childFilterOption = "$filter=" + String.join((CharSequence)" and ", filterList) + childFilter;
        String childTopOption = expandItem.getTopOption() != null ? "&$top=" + expandItem.getTopOption().getValue() : "";
        String childSkipOption = expandItem.getSkipOption() != null ? "&$skip=" + expandItem.getSkipOption().getValue() : "";
        String childOrderByOption = "";
        if (expandItem.getOrderByOption() != null) {
            HashSet<String> orderItems = new HashSet<String>();
            for (OrderByItem orderByItem : expandItem.getOrderByOption().getOrders()) {
                orderItems.add(((FilterExpressionToODataVisitor.VisitorContext)orderByItem.getExpression().accept((ExpressionVisitor)this.filterVisitor)).getValue() + (orderByItem.isDescending() ? " desc" : ""));
            }
            childOrderByOption = "&$orderby=" + String.join((CharSequence)",", orderItems);
        }
        String childSearchOption = "";
        if (expandItem.getSearchOption() != null) {
            childSearchOption = "&$search=" + this.getSearchExpressionString(expandItem.getSearchOption().getSearchExpression());
        }
        String finalQuery = childFilterOption + childTopOption + childSkipOption + childOrderByOption + childSearchOption;
        ODataRequest oDataRequest = new ODataRequest();
        oDataRequest.setRawBaseUri(parentRequest.getRawBaseUri());
        oDataRequest.setMethod(parentRequest.getMethod());
        oDataRequest.setRawRequestUri(parentRequest.getRawBaseUri() + target + "?" + finalQuery);
        oDataRequest.setRawODataPath("/" + target);
        oDataRequest.setProtocol(parentRequest.getProtocol());
        oDataRequest.setRawQueryPath(finalQuery);
        parentRequest.getAllHeaders().forEach((arg_0, arg_1) -> ((ODataRequest)oDataRequest).addHeader(arg_0, arg_1));
        return oDataRequest;
    }

    private UriInfo createChildUriInfo(ODataRequest child) {
        try {
            return new Parser(this.serviceMetadata.getEdm(), this.oData).parseUri(child.getRawODataPath(), child.getRawQueryPath(), null, child.getRawBaseUri());
        }
        catch (UriParserException | UriValidationException e) {
            throw new ExpansionException("An exception occurred while building child UriInfo", e);
        }
    }

    private String getSearchExpressionString(SearchExpression searchExpression) {
        String searchExpressionString = "";
        if (searchExpression == null) {
            return searchExpressionString;
        }
        if (searchExpression.isSearchUnary()) {
            searchExpressionString = searchExpression.asSearchUnary().getOperator().name() + " " + searchExpression.asSearchUnary().getOperand().getSearchTerm();
        } else if (searchExpression.isSearchTerm()) {
            searchExpressionString = searchExpression.asSearchTerm().getSearchTerm();
        } else if (searchExpression.isSearchBinary()) {
            SearchBinary searchBinary = searchExpression.asSearchBinary();
            searchExpressionString = "(" + this.getSearchExpressionString(searchBinary.getLeftOperand()) + ") " + searchBinary.getOperator().name() + " (" + this.getSearchExpressionString(searchBinary.getRightOperand()) + ") ";
        }
        return searchExpressionString;
    }
}

