/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.api.transformation;

import org.mule.extension.api.transformation.DateTransformType;
import org.mule.extension.api.transformation.DateTransformationTypeValueProvider;
import org.mule.extension.api.transformation.SQLIdentifiersDelimiter;
import org.mule.extension.api.transformation.SQLLimitRows;
import org.mule.extension.api.transformation.SearchFieldsAsType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.Expression;
import org.mule.sdk.api.annotation.values.OfValues;
import org.mule.sdk.api.meta.ExpressionSupport;

public class SQLSelectTransformationParameters {
    @Parameter
    @Summary(value="Enables $search transformation to WHERE clause")
    @Optional(defaultValue="true")
    private boolean searchTransformationEnabled;
    @Parameter
    @Optional
    @Summary(value="Enables full term match for $search")
    private boolean strictSearchTermMatch;
    @Parameter
    @Optional
    @Summary(value="Option to limit the number of rows")
    private SQLLimitRows sqlLimitRows;
    @Parameter
    @Optional
    @Summary(value="Option to delimit identifiers")
    private SQLIdentifiersDelimiter sqlIdentifiersDelimiter;
    @Parameter
    @OfValues(value=DateTransformationTypeValueProvider.class)
    @Optional(defaultValue="String")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Options for transformation of date/datetime values")
    private String dateTransformType;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Data type to which fields are type-casted for $search operation. If empty, no type-casting is performed.")
    private SearchFieldsAsType searchFieldsAsType;

    public SQLSelectTransformationParameters() {
        this.searchTransformationEnabled = true;
        this.strictSearchTermMatch = false;
        this.sqlLimitRows = SQLLimitRows.LIMIT;
        this.dateTransformType = DateTransformType.STRING.getStringValue();
        this.searchFieldsAsType = null;
    }

    public SQLSelectTransformationParameters(String dateTransformType) {
        this.searchTransformationEnabled = true;
        this.strictSearchTermMatch = false;
        this.sqlLimitRows = SQLLimitRows.LIMIT;
        this.dateTransformType = dateTransformType;
    }

    public SQLSelectTransformationParameters(boolean searchTransformationEnabled, boolean strictSearchTermMatch) {
        this.searchTransformationEnabled = searchTransformationEnabled;
        this.strictSearchTermMatch = strictSearchTermMatch;
        this.sqlLimitRows = SQLLimitRows.LIMIT;
    }

    public SQLSelectTransformationParameters(boolean searchTransformationEnabled, boolean strictSearchTermMatch, SQLLimitRows sqlLimitRows, SQLIdentifiersDelimiter delimiter) {
        this.searchTransformationEnabled = searchTransformationEnabled;
        this.strictSearchTermMatch = strictSearchTermMatch;
        this.sqlLimitRows = sqlLimitRows;
        this.sqlIdentifiersDelimiter = delimiter;
    }

    public boolean isStrictSearchTermMatch() {
        return this.strictSearchTermMatch;
    }

    public boolean isSearchTransformationEnabled() {
        return this.searchTransformationEnabled;
    }

    public SQLLimitRows getSqlLimitRows() {
        return this.sqlLimitRows;
    }

    public SQLIdentifiersDelimiter getSqlIdentifiersDelimiter() {
        return this.sqlIdentifiersDelimiter;
    }

    public String getDateTransformType() {
        return this.dateTransformType == null ? DateTransformType.STRING.getStringValue() : this.dateTransformType;
    }

    public SearchFieldsAsType getSearchFieldsAsType() {
        return this.searchFieldsAsType;
    }
}

