/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.server.api.ODataRequest;
import org.mule.extension.internal.exception.error.ODataError;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class APIKitODataRequest
extends ODataRequest {
    private long cursorStreamPosition = 0L;
    private byte[] bodyCopy;
    private String correlationId;

    public void setBody(InputStream body) {
        if (body instanceof Cursor) {
            this.cursorStreamPosition = ((Cursor)body).getPosition();
            super.setBody(body);
        } else {
            try {
                this.bodyCopy = body == null ? new byte[]{} : IOUtils.toByteArray((InputStream)body);
            }
            catch (IOException e) {
                throw new ModuleException("Unable to read request body", (ErrorTypeDefinition)ODataError.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
    }

    public InputStream getBody() {
        InputStream body = super.getBody();
        if (body instanceof Cursor) {
            try {
                ((Cursor)body).seek(this.cursorStreamPosition);
                return body;
            }
            catch (IOException e) {
                throw new ModuleException("Unable to read request body", (ErrorTypeDefinition)ODataError.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        return new ByteArrayInputStream(this.bodyCopy);
    }

    public String getHeader(String name) {
        String headerValue = super.getHeader(name);
        if (headerValue != null && !headerValue.isEmpty()) {
            return headerValue;
        }
        if ("If-Match".equals(name)) {
            String ifNoneMatchHeaderValue = super.getHeader("If-None-Match");
            return ifNoneMatchHeaderValue != null && !ifNoneMatchHeaderValue.isEmpty() ? ifNoneMatchHeaderValue : "*";
        }
        return headerValue;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }
}

