/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.transformation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.core.uri.parser.FilterParser;
import org.apache.olingo.server.core.uri.parser.OrderByParser;
import org.apache.olingo.server.core.uri.parser.UriTokenizer;
import org.mule.extension.api.transformation.SQLSelectTransformationParameters;
import org.mule.extension.internal.exception.SQLTransformationException;
import org.mule.extension.internal.transformation.DelimitIdentifiers;
import org.mule.extension.internal.transformation.FilterExpressionToSQLVisitor;
import org.mule.extension.internal.transformation.PaginationBuilder;
import org.mule.extension.internal.transformation.SQLPreparedStatementBuilder;
import org.mule.extension.internal.transformation.SQLPreparedStatementQuery;
import org.mule.extension.internal.transformation.SearchMatchByEntrySQLTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLSelectQueryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLSelectQueryBuilder.class);
    private String filter;
    private String select;
    private String search;
    private String orderBy;
    private Integer skip;
    private Integer top;
    private Integer skiptoken;
    private Integer pageSize;
    private List<String> entityTypeFields;
    private String entitySetName;
    private String databaseSchema;
    private String entityTypeName;
    private Map<String, String> entityTypeKeys;
    private SQLSelectTransformationParameters sqlSelectTransformationParameters;
    private DelimitIdentifiers delimitIdentifiers;
    private final FilterParser filterParser;
    private final OrderByParser orderByParser;
    private final String containerNamespace;
    private final Edm edm;

    public SQLSelectQueryBuilder(Edm edm, OData odata) {
        this.filterParser = new FilterParser(edm, odata);
        this.orderByParser = new OrderByParser(edm, odata);
        this.containerNamespace = edm.getEntityContainer().getNamespace();
        this.edm = edm;
    }

    public SQLSelectQueryBuilder withEntityTypeFields(List<String> entityTypeFields) {
        this.entityTypeFields = entityTypeFields;
        return this;
    }

    public SQLSelectQueryBuilder withEntitySetName(String entitySetName) {
        this.entitySetName = entitySetName;
        return this;
    }

    public SQLSelectQueryBuilder withEntityTypeName(String entityTypeName) {
        this.entityTypeName = entityTypeName;
        return this;
    }

    public SQLSelectQueryBuilder withEntityTypeKeys(Map<String, String> entityTypeKeys) {
        this.entityTypeKeys = entityTypeKeys;
        return this;
    }

    public SQLSelectQueryBuilder withSystemQueryOptions(Map<String, String> systemQueryOptions) {
        if (systemQueryOptions != null) {
            this.skiptoken = SQLSelectQueryBuilder.getInteger(systemQueryOptions, "skiptoken");
            this.skip = SQLSelectQueryBuilder.getInteger(systemQueryOptions, "skip");
            this.top = SQLSelectQueryBuilder.getInteger(systemQueryOptions, "top");
            this.filter = systemQueryOptions.get("filter");
            this.select = systemQueryOptions.get("select");
            this.search = systemQueryOptions.get("search");
            this.orderBy = systemQueryOptions.get("orderby");
        }
        return this;
    }

    private static Integer getInteger(Map<String, String> systemQueryOptions, String key) {
        String value = systemQueryOptions.get(key);
        try {
            if (!StringUtils.isBlank((CharSequence)value)) {
                return Integer.valueOf(value);
            }
            return null;
        }
        catch (NumberFormatException e) {
            throw new SQLTransformationException(String.format("Only Integer %s is supported", key), e);
        }
    }

    public SQLSelectQueryBuilder withPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public SQLSelectQueryBuilder withTransformationParameters(SQLSelectTransformationParameters sqlSelectTransformationParameters) {
        this.sqlSelectTransformationParameters = sqlSelectTransformationParameters;
        return this;
    }

    public SQLSelectQueryBuilder withDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    public SQLPreparedStatementQuery build() {
        SQLSelectQueryBuilder.validateEntitySetExists(this.entitySetName, this.edm);
        this.delimitIdentifiers = new DelimitIdentifiers(this.sqlSelectTransformationParameters.getSqlIdentifiersDelimiter());
        EdmEntityType entityType = this.getEntityType();
        SQLPreparedStatementBuilder sqlPreparedStatementBuilder = new SQLPreparedStatementBuilder();
        PaginationBuilder paginationBuilder = new PaginationBuilder(this.delimitIdentifiers).withEntityType(entityType).withLimitRows(this.sqlSelectTransformationParameters.getSqlLimitRows()).withOrderBy(this.orderBy).withSkip(this.skip).withPageSize(this.pageSize).withSkipToken(this.skiptoken).withOrderByParser(this.orderByParser).withTop(this.top);
        String sqlQuery = String.format("%s%s%s%s", this.generateSelect(), this.generateFrom(), this.generateWhere(sqlPreparedStatementBuilder, entityType), paginationBuilder.build(sqlPreparedStatementBuilder));
        return new SQLPreparedStatementQuery(sqlQuery, sqlPreparedStatementBuilder.getParameters());
    }

    private String generateWhere(SQLPreparedStatementBuilder sqlPreparedStatementBuilder, EdmEntityType entityType) {
        String whereClause;
        String rawOdataFilter = this.generateOdataFilter(this.entityTypeKeys);
        if (StringUtils.isNotBlank((CharSequence)this.filter)) {
            rawOdataFilter = StringUtils.isNotBlank((CharSequence)rawOdataFilter) ? this.filter + " and (" + rawOdataFilter + ")" : this.filter;
        }
        String string = whereClause = StringUtils.isBlank((CharSequence)rawOdataFilter) ? "" : " WHERE " + this.getSQLFilter(rawOdataFilter, sqlPreparedStatementBuilder, entityType);
        if (StringUtils.isNotBlank((CharSequence)this.search) && this.sqlSelectTransformationParameters.isSearchTransformationEnabled()) {
            whereClause = StringUtils.isBlank((CharSequence)whereClause) ? " WHERE " : whereClause + " AND ";
            whereClause = whereClause + "(" + new SearchMatchByEntrySQLTranslator(this.delimitIdentifiers).transformToSqlWhereClause(this.search, this.entityTypeFields, this.sqlSelectTransformationParameters.isStrictSearchTermMatch(), sqlPreparedStatementBuilder) + ")";
        }
        return whereClause;
    }

    private String generateFrom() {
        String schemaPrefix = Optional.ofNullable(this.databaseSchema).map(s -> this.delimitIdentifiers.delimit(this.databaseSchema) + ".").orElse("");
        return " FROM " + schemaPrefix + this.delimitIdentifiers.delimit(this.entitySetName);
    }

    private String generateSelect() {
        List<String> fields = this.select == null || "*".equals(this.select) ? this.entityTypeFields : Arrays.asList(this.select.split(","));
        return "SELECT " + String.join((CharSequence)", ", this.delimitIdentifiers.delimit(fields));
    }

    private String generateOdataFilter(Map<String, String> entityTypeKeys) {
        if (entityTypeKeys == null) {
            return "";
        }
        StringBuilder filterBuilder = new StringBuilder();
        int counter = 0;
        for (Map.Entry<String, String> entityTypeKey : entityTypeKeys.entrySet()) {
            if (counter != 0) {
                filterBuilder.append(" and ");
            }
            filterBuilder.append(entityTypeKey.getKey());
            filterBuilder.append(" eq ");
            filterBuilder.append(entityTypeKey.getValue());
            ++counter;
        }
        return filterBuilder.toString();
    }

    private String getSQLFilter(String rawFilter, SQLPreparedStatementBuilder sqlPreparedStatementBuilder, EdmEntityType entityType) {
        String dateTransformType = this.sqlSelectTransformationParameters.getDateTransformType();
        FilterExpressionToSQLVisitor expressionVisitor = new FilterExpressionToSQLVisitor(sqlPreparedStatementBuilder, this.delimitIdentifiers, dateTransformType);
        UriTokenizer filterTokenizer = new UriTokenizer(rawFilter);
        try {
            Expression expression = this.filterParser.parse(filterTokenizer, (EdmType)entityType, Collections.emptyList(), Collections.emptyMap()).getExpression();
            return (String)expression.accept((ExpressionVisitor)expressionVisitor);
        }
        catch (Exception e) {
            throw new SQLTransformationException("An error occurred while generating SQL transformation for $filter", e);
        }
    }

    private EdmEntityType getEntityType() {
        FullQualifiedName fullQualifiedName = new FullQualifiedName(this.containerNamespace, this.entityTypeName);
        return this.edm.getEntityType(fullQualifiedName);
    }

    private static void validateEntitySetExists(String entitySetName, Edm edm) {
        EdmEntitySet edmEntitySet = edm.getSchemas().stream().map(schema -> schema.getEntityContainer().getEntitySet(entitySetName)).filter(Objects::nonNull).findFirst().orElse(null);
        if (edmEntitySet == null) {
            LOGGER.warn(String.format("No EntitySet that matches provided name \"%s\" found", entitySetName));
        }
    }
}

