/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.EdmEntityTypeImpl;
import org.apache.olingo.commons.core.edm.primitivetype.AbstractGeospatialType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBoolean;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDate;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDuration;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGuid;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSingle;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.CustomQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.UriResourceEntitySetImpl;
import org.apache.olingo.server.core.uri.UriResourceNavigationPropertyImpl;
import org.mule.extension.api.constants.HttpMethod;
import org.mule.extension.api.routing.ListenerRequestAttributes;
import org.mule.extension.api.routing.RouteOutputAttributes;
import org.mule.extension.internal.model.APIKitODataResponse;
import org.mule.extension.internal.model.builders.RouteOutputAttributesBuilder;
import org.mule.extension.internal.routing.ConfigurationRoutingKey;
import org.mule.extension.internal.routing.RoutingKey;
import org.mule.extension.internal.routing.SourceKind;
import org.mule.extension.internal.sources.SourceConfiguration;
import org.mule.extension.internal.utils.ObjectMapperFactory;
import org.mule.extension.internal.utils.URICoder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class OlingoUtils {
    private static final Set<Character> allowedCharsWhenFormattingString = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('\''), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('='), Character.valueOf(':'), Character.valueOf('@'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('!'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf(';'))));

    public static APIKitODataResponse getAPIKitResponse(ODataResponse response) {
        return (APIKitODataResponse)response;
    }

    public static Result<InputStream, RouteOutputAttributes> toResult(ODataResponse response) {
        APIKitODataResponse apikitResponse = OlingoUtils.getAPIKitResponse(response);
        return Result.builder().output((Object)response.getContent()).attributes((Object)OlingoUtils.getOutputAttributes(apikitResponse)).mediaType(OlingoUtils.getContentMediaType(response)).build();
    }

    public static Optional<EdmEntityType> getReturnEntityType(UriInfo uriInfo) {
        UriResource uriResource = OlingoUtils.getUriLastResourcePart(uriInfo);
        return Optional.ofNullable(OlingoUtils.getEdmEntityType(uriInfo.getUriResourceParts(), uriResource));
    }

    public static Optional<EdmEntitySet> getReturnEntitySet(UriInfo uriInfo, Edm edm) {
        List pathParts = uriInfo.getUriResourceParts();
        if (pathParts.isEmpty()) {
            return Optional.empty();
        }
        UriResource firstPart = (UriResource)pathParts.get(0);
        pathParts = pathParts.subList(1, pathParts.size());
        if (!(firstPart instanceof UriResourceEntitySet)) {
            return Optional.empty();
        }
        EdmEntitySet currentEntitySet = ((UriResourceEntitySet)firstPart).getEntitySet();
        for (UriResource part : pathParts) {
            if (!(part instanceof UriResourceNavigation)) {
                return Optional.empty();
            }
            EdmBindingTarget target = currentEntitySet.getRelatedBindingTarget(part.getSegmentValue());
            if (target == null) {
                target = OlingoUtils.findEntitySetForEntity(((UriResourceNavigation)part).getProperty().getType(), edm).orElse(null);
            }
            if (!(target instanceof EdmEntitySet)) {
                return Optional.empty();
            }
            currentEntitySet = (EdmEntitySet)target;
        }
        return Optional.of(currentEntitySet);
    }

    public static Optional<EdmEntitySet> findEntitySetForEntity(EdmEntityType entity, Edm edm) {
        FullQualifiedName entityFQN = entity.getFullQualifiedName();
        return edm.getSchemas().stream().flatMap(schema -> schema.getEntityContainer().getEntitySets().stream()).filter(entitySet -> entitySet.getEntityType().getFullQualifiedName().equals((Object)entityFQN)).findAny();
    }

    public static UriResource getUriLastResourcePart(UriInfo uriInfo) {
        return uriInfo instanceof UriInfoImpl ? ((UriInfoImpl)uriInfo).getLastResourcePart() : (UriResource)uriInfo.getUriResourceParts().get(uriInfo.getUriResourceParts().size() - 1);
    }

    public static Optional<String> getEntitySetName(UriInfo uriInfo) {
        UriResource uriResource = OlingoUtils.getEntityContainerUriResource(uriInfo.getUriResourceParts());
        if (uriResource == null) {
            return Optional.empty();
        }
        if (uriResource instanceof UriResourceEntitySetImpl) {
            UriResourceEntitySetImpl uriResourceEntitySet = (UriResourceEntitySetImpl)uriResource;
            return Optional.ofNullable(uriResourceEntitySet.getEntitySet().getName());
        }
        if (uriResource instanceof UriResourceNavigationPropertyImpl) {
            UriResourceNavigationPropertyImpl uriResourceNavigationProperty = (UriResourceNavigationPropertyImpl)uriResource;
            return Optional.ofNullable(uriResourceNavigationProperty.getProperty().getName());
        }
        return Optional.empty();
    }

    public static Optional<EdmEntitySet> getEntitySet(UriInfo uriInfo) {
        UriResource uriResource = OlingoUtils.getEntityContainerUriResource(uriInfo.getUriResourceParts());
        if (uriResource == null) {
            return Optional.empty();
        }
        if (uriResource instanceof UriResourceEntitySet) {
            UriResourceEntitySet uriResourceEntitySet = (UriResourceEntitySet)uriResource;
            return Optional.ofNullable(uriResourceEntitySet.getEntitySet());
        }
        return Optional.empty();
    }

    public static Map<String, String> getEntityTypeKeysFromUriParameters(List<UriResource> uriResources) {
        HashMap<String, String> entityTypeKeys = new HashMap<String, String>();
        uriResources.forEach(value -> {
            if (value instanceof UriResourceEntitySet) {
                UriResourceEntitySet entitySet = (UriResourceEntitySet)value;
                entityTypeKeys.putAll(entitySet.getKeyPredicates().stream().collect(Collectors.toMap(uriParameter -> uriParameter.getName(), uriParameter -> uriParameter.getText())));
            } else if (value instanceof UriResourceNavigation) {
                UriResourceNavigation navigation = (UriResourceNavigation)value;
                entityTypeKeys.putAll(navigation.getKeyPredicates().stream().collect(Collectors.toMap(uriParameter -> uriParameter.getName(), uriParameter -> uriParameter.getText())));
            }
        });
        return entityTypeKeys;
    }

    public static List<String> getEntityTypeFields(EdmEntityType entityType) {
        if (entityType == null) {
            return new ArrayList<String>();
        }
        Map properties = ((EdmEntityTypeImpl)entityType).getProperties();
        return new ArrayList<String>(properties.keySet());
    }

    public static String getUriPath(List<UriResource> parts) {
        StringBuilder stringBuilder = new StringBuilder();
        parts.forEach(value -> {
            if (UriResourceKind.entitySet.equals((Object)value.getKind()) || UriResourceKind.navigationProperty.equals((Object)value.getKind())) {
                stringBuilder.append("/");
                stringBuilder.append(value.getSegmentValue());
            }
        });
        return stringBuilder.toString();
    }

    public static RoutingKey<InputStream, ListenerRequestAttributes, SourceConfiguration> getRoutingKey(ODataRequest request, UriInfo uriInfo, SourceKind kind) {
        return new RoutingKey<InputStream, ListenerRequestAttributes, SourceConfiguration>(HttpMethod.valueOf(request.getMethod().name()), OlingoUtils.getUriPath(uriInfo.getUriResourceParts()), kind);
    }

    public static Map<String, String> getSystemQueryOptions(List<SystemQueryOption> systemQueryOptionOptions) {
        HashMap<String, String> options = new HashMap<String, String>();
        systemQueryOptionOptions.forEach(sqo -> options.put(sqo.getName().substring(1), sqo.getText()));
        return options;
    }

    public static MultiMap<String, String> getCustomQueryOptions(List<CustomQueryOption> customQueryOptions) {
        MultiMap options = new MultiMap();
        customQueryOptions.forEach(cqo -> {
            String cfr_ignored_0 = (String)options.put((Object)cqo.getName(), (Object)cqo.getText());
        });
        return options;
    }

    public static Optional<String> getEntityTypeName(EdmEntityType entityType) {
        return entityType == null ? Optional.empty() : Optional.ofNullable(entityType.getName());
    }

    private static RouteOutputAttributes getOutputAttributes(APIKitODataResponse response) {
        return RouteOutputAttributesBuilder.builder().withStatusCode(response.getStatusCode()).withMultipleEntryHeadersMap(response.getAllHeaders()).withFlowAttributes(response.getFlowAttributes()).build();
    }

    private static MediaType getContentMediaType(ODataResponse response) {
        String contentType = response.getHeader("Content-Type");
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{contentType}) ? MediaType.parse((String)contentType) : MediaType.ANY;
    }

    private static EdmEntityType getEdmEntityType(List<UriResource> uriResourceParts, UriResource resourcePart) {
        EdmType edmType = OlingoUtils.getUriResourcePartType(resourcePart);
        if (edmType == null) {
            return null;
        }
        EdmTypeKind typeKind = edmType.getKind();
        if (EdmTypeKind.ENTITY.equals((Object)typeKind)) {
            return (EdmEntityType)edmType;
        }
        if (EdmTypeKind.PRIMITIVE.equals((Object)typeKind) || EdmTypeKind.COMPLEX.equals((Object)typeKind)) {
            int uriResourcePartsSize = uriResourceParts.size();
            return OlingoUtils.getEdmEntityType(uriResourceParts.subList(0, uriResourcePartsSize - 1), uriResourceParts.get(uriResourcePartsSize - 1));
        }
        return null;
    }

    private static UriResource getEntityContainerUriResource(List<UriResource> uriResourceParts) {
        int uriResourcePartsSize = uriResourceParts.size();
        if (uriResourcePartsSize == 0) {
            return null;
        }
        UriResource uriResource = uriResourceParts.get(uriResourcePartsSize - 1);
        if (uriResource instanceof UriResourceEntitySetImpl || uriResource instanceof UriResourceNavigationPropertyImpl) {
            return uriResource;
        }
        return OlingoUtils.getEntityContainerUriResource(uriResourceParts.subList(0, uriResourcePartsSize - 1));
    }

    private static EdmType getUriResourcePartType(UriResource resourcePart) {
        if (resourcePart instanceof UriResourcePartTyped) {
            return ((UriResourcePartTyped)resourcePart).getType();
        }
        return null;
    }

    public static Optional<EdmEntityType> getReturnEntityType(ConfigurationRoutingKey routingKey, Edm edm) {
        String[] routingKeyPathSegments = routingKey.getPath().substring(1).split("/");
        if (routingKeyPathSegments.length == 0) {
            return Optional.empty();
        }
        EdmEntitySet entitySet = edm.getEntityContainer().getEntitySet(routingKeyPathSegments[0]);
        if (entitySet == null) {
            return Optional.empty();
        }
        EdmEntityType entityType = entitySet.getEntityType();
        for (int i = 1; i < routingKeyPathSegments.length; ++i) {
            EdmNavigationProperty navigationProperty = entityType.getNavigationProperty(routingKeyPathSegments[i]);
            if (navigationProperty == null) {
                return Optional.empty();
            }
            entityType = navigationProperty.getType();
        }
        return Optional.ofNullable(entityType);
    }

    public static String formatODataValue(EdmType type, Object o, boolean isCollection) {
        if (o == null) {
            return "null";
        }
        if (isCollection) {
            OlingoUtils.expectType(type, o, List.class);
            try {
                return ObjectMapperFactory.buildJsonObjectMapper().writeValueAsString(o);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Failed to serialize the field value", e);
            }
        }
        if (type instanceof EdmComplexType) {
            OlingoUtils.expectType(type, o, Map.class);
            try {
                return ObjectMapperFactory.buildJsonObjectMapper().writeValueAsString(o);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Failed to serialize the field value", e);
            }
        }
        if (EdmBoolean.getInstance().equals((Object)type)) {
            OlingoUtils.expectType(type, o, Boolean.class);
            return o.toString();
        }
        if (OlingoUtils.someoneEquals(type, EdmGuid.getInstance(), EdmDate.getInstance(), EdmDateTimeOffset.getInstance(), EdmTimeOfDay.getInstance())) {
            OlingoUtils.expectType(type, o, String.class);
            return o.toString();
        }
        if (EdmString.getInstance().equals((Object)type)) {
            OlingoUtils.expectType(type, o, String.class);
            return "'" + URICoder.encode(o.toString().replace("'", "''"), allowedCharsWhenFormattingString) + "'";
        }
        if (OlingoUtils.someoneEquals(type, EdmDecimal.getInstance(), EdmDouble.getInstance(), EdmSingle.getInstance())) {
            Double d;
            OlingoUtils.expectType(type, o, Double.class, Integer.class, Long.class, BigInteger.class, String.class);
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof Double && (d = (Double)o).isInfinite()) {
                return d > 0.0 ? "INF" : "-INF";
            }
            return o.toString();
        }
        if (OlingoUtils.someoneEquals(type, EdmSByte.getInstance(), EdmByte.getInstance(), EdmInt16.getInstance(), EdmInt32.getInstance(), EdmInt64.getInstance())) {
            OlingoUtils.expectType(type, o, Integer.class, Long.class);
            return o.toString();
        }
        if (EdmDuration.getInstance().equals((Object)type)) {
            OlingoUtils.expectType(type, o, String.class);
            return "'" + o + "'";
        }
        if (type instanceof EdmEnumType) {
            OlingoUtils.expectType(type, o, String.class);
            return "'" + o + "'";
        }
        if (EdmBinary.getInstance().equals((Object)type)) {
            OlingoUtils.expectType(type, o, String.class);
            return "binary'" + o + "'";
        }
        if (type instanceof AbstractGeospatialType) {
            throw new IllegalArgumentException("Geography and geometry types are not yet supported (got `type` " + type + ")");
        }
        if (type instanceof EdmTypeDefinition) {
            return OlingoUtils.formatODataValue((EdmType)((EdmTypeDefinition)type).getUnderlyingType(), o, false);
        }
        throw new IllegalArgumentException("Escaping for properties of `type` " + type + " is not yet supported");
    }

    private static boolean someoneEquals(Object o, Object ... options) {
        for (Object option : options) {
            if (!option.equals(o)) continue;
            return true;
        }
        return false;
    }

    private static void expectType(EdmType type, Object o, Class<?> ... classes) {
        for (Class<?> c : classes) {
            if (!c.isInstance(o)) continue;
            return;
        }
        throw new IllegalArgumentException("`type` is " + type + ", expected an instance in " + Arrays.toString(classes) + " for `value` but got: " + o.getClass());
    }
}

