/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.internal.sources;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.mule.extension.api.constants.HttpMethod;
import org.mule.extension.api.serialization.SuccessResponse;
import org.mule.extension.internal.ODataConfig;
import org.mule.extension.internal.exception.SubFlowFailureException;
import org.mule.extension.internal.routing.ConfigurationRoutingKey;
import org.mule.extension.internal.routing.DefaultRoutingContext;
import org.mule.extension.internal.routing.RoutingKey;
import org.mule.extension.internal.routing.RoutingManager;
import org.mule.extension.internal.sources.ExpansionParameters;
import org.mule.extension.internal.sources.SourceConfiguration;
import org.mule.extension.internal.sources.SystemQueryOptionsParameters;
import org.mule.extension.internal.utils.OlingoUtils;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceCompletionCallback;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.slf4j.Logger;

public abstract class BaseSource<T, A>
extends Source<T, A>
implements Initialisable {
    protected final String ROUTING_CONTEXT_KEY = "routingContext";
    @Config
    protected ODataConfig odataConfig;
    @MetadataKeyId
    @ParameterGroup(name="routingKey")
    protected ConfigurationRoutingKey routingKey;
    @ParameterGroup(name="Expansion parameters", showInDsl=true)
    @Summary(value="Set of $expansion-related parameters")
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    protected ExpansionParameters expansionParameters;
    @ParameterGroup(name="Supported System Query Options", showInDsl=true)
    @Summary(value="Set of supported system query options")
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    protected SystemQueryOptionsParameters systemQueryOptionsParameters;
    @Inject
    private ExpressionManager expressionManager;
    protected ComponentLocation location;

    protected RoutingManager getRoutingManager() {
        return this.odataConfig.getRoutingManager();
    }

    public void onStart(SourceCallback<T, A> sourceCallback) {
        boolean isGetMethod = HttpMethod.GET.equals((Object)this.routingKey.getMethod());
        if (!isGetMethod && !this.expansionParameters.isEmpty()) {
            this.getLogger().warn("Non-empty expansion parameters ignored for {} (uses the {} method instead of GET)", (Object)this.location.getLocation(), (Object)this.routingKey.getMethod());
        }
        Function callback = input -> {
            SourceCallbackContext ctx = sourceCallback.createContext();
            CompletableFuture completableResult = new CompletableFuture();
            DefaultRoutingContext routingContext = new DefaultRoutingContext(completableResult);
            ctx.addVariable("routingContext", routingContext);
            sourceCallback.handle(input, ctx);
            return routingContext;
        };
        this.getRoutingManager().registerListener(this.getRoutingKey(), callback, new SourceConfiguration(isGetMethod ? this.expansionParameters : null, this.systemQueryOptionsParameters));
    }

    @OnError
    public void onError(Error error, SourceCallbackContext callbackContext, SourceCompletionCallback completionCallback) {
        DefaultRoutingContext routingContext = this.getRoutingContext(callbackContext);
        routingContext.setSourceCompletionCallback(completionCallback);
        Object e = error.getCause();
        if (e instanceof ModuleException) {
            e = new SubFlowFailureException(error);
        }
        routingContext.getFlowCompletableResponse().completeExceptionally((Throwable)e);
    }

    public void onStop() {
        this.getRoutingManager().unregisterListenerContext(this.getRoutingKey());
    }

    @OnTerminate
    public void onTerminate(SourceResult sourceResult) {
        DefaultRoutingContext routingContext = this.getRoutingContext(sourceResult.getSourceCallbackContext());
        if (routingContext != null) {
            sourceResult.getInvocationError().ifPresent(error -> routingContext.getFlowCompletableResponse().completeExceptionally(error.getCause()));
            sourceResult.getResponseError().ifPresent(error -> routingContext.getFlowCompletableResponse().completeExceptionally(error.getCause()));
        }
    }

    protected DefaultRoutingContext getRoutingContext(SourceCallbackContext callbackContext) {
        return (DefaultRoutingContext)callbackContext.getVariable("routingContext").orElseThrow(() -> new IllegalStateException("Routing context not found"));
    }

    public void initialise() throws InitialisationException {
        String routingKeyPath = this.routingKey.getPath();
        if (routingKeyPath == null || routingKeyPath.isEmpty() || !routingKeyPath.startsWith("/")) {
            return;
        }
        EdmEntityType entityType = OlingoUtils.getReturnEntityType(this.routingKey, this.odataConfig.getHandler().getEdm()).orElse(null);
        if (entityType == null) {
            return;
        }
        List navigationPropertyNames = entityType.getNavigationPropertyNames();
        List<String> unknownNavigationPropertyNames = this.expansionParameters.getExpandableProperties().stream().filter(prop -> !navigationPropertyNames.contains(prop)).collect(Collectors.toList());
        if (!unknownNavigationPropertyNames.isEmpty()) {
            throw new InitialisationException(BaseSource.getI18nMessage(entityType, unknownNavigationPropertyNames), (Initialisable)this);
        }
    }

    private static I18nMessage getI18nMessage(EdmEntityType entityType, List<String> unknownNavigationPropertyNames) {
        StringBuilder messageBuilder = new StringBuilder().append("Expandable ");
        messageBuilder = unknownNavigationPropertyNames.size() > 1 ? messageBuilder.append("properties [" + String.join((CharSequence)", ", unknownNavigationPropertyNames) + "] do ") : messageBuilder.append("property \"" + unknownNavigationPropertyNames.get(0) + "\" does ");
        messageBuilder = messageBuilder.append("not match any navigation property name of entity type " + entityType.getName());
        return I18nMessageFactory.createStaticMessage((String)messageBuilder.toString());
    }

    protected abstract RoutingKey<T, A, SourceConfiguration> getRoutingKey();

    protected abstract Logger getLogger();

    protected void onSuccess(SuccessResponse successResponse, SourceCallbackContext callbackContext, SourceCompletionCallback completionCallback) {
        DefaultRoutingContext routingContext = this.getRoutingContext(callbackContext);
        routingContext.setSourceCompletionCallback(completionCallback);
        routingContext.getFlowCompletableResponse().complete(successResponse);
    }

    protected TypedValue<T> convert(TypedValue<?> payload, Class<T> outputClazz, MediaType mediaType) {
        DataType dataType = DataType.builder().type(outputClazz).mediaType(mediaType).build();
        BindingContext context = BindingContext.builder().addBinding("payload", payload).build();
        TypedValue result = this.expressionManager.evaluate("#[payload]", dataType, context);
        if (!InputStream.class.equals(outputClazz)) {
            return result;
        }
        if (!(result.getValue() instanceof CursorStreamProvider)) {
            return result;
        }
        return new TypedValue(outputClazz.cast(((CursorStreamProvider)result.getValue()).openCursor()), result.getDataType());
    }
}

