/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.internal;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.extension.http.api.request.proxy.HttpProxyConfig;
import org.mule.extension.oauth2.api.tokenmanager.TokenManagerConfig;
import org.mule.extension.oauth2.internal.DeferredExpressionResolver;
import org.mule.extension.oauth2.internal.OAuthUtils;
import org.mule.extension.oauth2.internal.ParameterExtractor;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.builder.OAuthDancerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGrantType
implements HttpRequestAuthentication,
MuleContextAware,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGrantType.class);
    private static final String ACCESS_TOKEN_EXPRESSION = "#[payload.access_token]";
    private static final String REFRESH_TOKEN_EXPRESSION = "#[payload.refresh_token]";
    private static final String EXPIRATION_TIME_EXPRESSION = "#[payload.expires_in]";
    protected MuleContext muleContext;
    protected DeferredExpressionResolver resolver;
    @Parameter
    private String clientId;
    @Parameter
    private String clientSecret;
    @Parameter
    @Optional
    private String scopes;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    protected TokenManagerConfig tokenManager;
    @Parameter
    private String tokenUrl;
    @Parameter
    @Optional(defaultValue="#[payload.access_token]")
    protected Literal<String> responseAccessToken;
    @Parameter
    @Optional(defaultValue="#[payload.refresh_token]")
    protected Literal<String> responseRefreshToken;
    @Parameter
    @Optional(defaultValue="#[payload.expires_in]")
    protected Literal<String> responseExpiresIn;
    @Parameter
    @Alias(value="custom-parameter-extractors")
    @Optional
    protected List<ParameterExtractor> parameterExtractors;
    @Parameter
    @Optional(defaultValue="#[attributes.statusCode == 401 or attributes.statusCode == 403]")
    private Literal<Boolean> refreshTokenWhen;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="TLS Configuration")
    @Placement(tab="TLS")
    private TlsContextFactory tlsContextFactory;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private HttpProxyConfig proxyConfig;
    @Inject
    protected OAuthService oAuthService;

    protected void initTokenManager() throws InitialisationException {
        if (this.tokenManager == null) {
            this.tokenManager = TokenManagerConfig.createDefault(this.muleContext);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.tokenManager, (MuleContext)this.muleContext);
    }

    protected OAuthDancerBuilder configureBaseDancer(OAuthDancerBuilder dancerBuilder) throws InitialisationException {
        TlsContextFactory contextFactory = this.getTlsContextFactory();
        if (contextFactory != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.getTlsContextFactory());
        }
        dancerBuilder.tokenUrl(this.tokenUrl, contextFactory, (ProxyConfig)this.proxyConfig);
        dancerBuilder.scopes(this.getScopes()).encoding(SystemUtils.getDefaultEncoding((MuleContext)this.muleContext)).responseAccessTokenExpr(this.resolver.getExpression(this.getResponseAccessToken())).responseRefreshTokenExpr(this.resolver.getExpression(this.getResponseRefreshToken())).responseExpiresInExpr(this.resolver.getExpression(this.getResponseExpiresIn())).customParametersExtractorsExprs(this.getCustomParameterExtractors().stream().collect(Collectors.toMap(extractor -> extractor.getParamName(), extractor -> this.resolver.getExpression(extractor.getValue()))));
        return dancerBuilder;
    }

    public abstract Object getDancer();

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.tokenManager);
        LifecycleUtils.startIfNeeded((Object)this.getDancer());
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.getDancer());
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.getDancer(), (Logger)LOGGER);
    }

    protected String buildAuthorizationHeaderContent(String accessToken) {
        return "Bearer " + accessToken;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.resolver = new DeferredExpressionResolver((MuleExpressionLanguage)muleContext.getExpressionManager());
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractGrantType) {
            AbstractGrantType other = (AbstractGrantType)obj;
            return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientSecret, other.clientSecret) && Objects.equals(this.scopes, other.scopes) && Objects.equals(this.tokenManager, other.tokenManager) && Objects.equals(this.tokenUrl, other.tokenUrl) && OAuthUtils.literalEquals(this.responseAccessToken, other.responseAccessToken) && OAuthUtils.literalEquals(this.responseRefreshToken, other.responseRefreshToken) && OAuthUtils.literalEquals(this.responseExpiresIn, other.responseExpiresIn) && Objects.equals(this.parameterExtractors, other.parameterExtractors) && OAuthUtils.literalEquals(this.refreshTokenWhen, other.refreshTokenWhen) && Objects.equals(this.tlsContextFactory, other.tlsContextFactory) && Objects.equals(this.proxyConfig, other.proxyConfig);
        }
        return false;
    }

    public int hashCode() {
        return 31 * Objects.hash(this.clientId, this.clientSecret, this.scopes, this.tokenManager, this.tokenUrl, this.parameterExtractors, this.tlsContextFactory, this.proxyConfig) * OAuthUtils.literalHashCodes(this.responseAccessToken, this.responseRefreshToken, this.responseExpiresIn, this.refreshTokenWhen);
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getClientId() {
        return this.clientId;
    }

    public abstract boolean isEncodeClientCredentialsInBody();

    public String getScopes() {
        return this.scopes;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public Literal<Boolean> getRefreshTokenWhen() {
        return this.refreshTokenWhen;
    }

    public Literal<String> getResponseAccessToken() {
        return this.responseAccessToken;
    }

    public Literal<String> getResponseRefreshToken() {
        return this.responseRefreshToken;
    }

    public Literal<String> getResponseExpiresIn() {
        return this.responseExpiresIn;
    }

    public List<ParameterExtractor> getCustomParameterExtractors() {
        return this.parameterExtractors != null ? this.parameterExtractors : Collections.emptyList();
    }

    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }
}

